//************* software description  2009/03/10 ***********************
// 3-level Classic DTC with and without NP compensation 
// 2-level classic DTC with 72 degree vector
// 2-level Classic DTC with 72 and 36 degree vector selection using speed info
// 1. the presetting in Dave of 2-level is same	as 3-level
// 2. Regarding measuring the DC-link Vdc, 2-level uses one channel of A/D while 3-level uses 2 channesls of A/D
// 3. d1-d1 and d3-q3 stator flux observer for 2-level and 3-level are same.   


//#include "sine.h"
#include "SpaceVector.h"
#include <stdio.h>
#include <math.h>
#include <stdlib.h>   
#include "ADC0.h"
   //unsigned int StartFlag=0x0;  //StartFlag=0x0, control initialization
   unsigned int SectorNum;	    //Sector number in the d1q1 plane
   unsigned int PhaseShftNum;
   unsigned int SetTimer0;
   unsigned int ResetTimer1;
   unsigned short int DataOutput;
   
   		
  // unsigned int i;		//Temp register
   
   unsigned int SwitchOnCnt=0;
   
   int tempi1;			//Temp register
   int tempi1_1;
   int tempi2;
   int DataCNT;
   int Result;
   int Source;
   int SpeedTempValue1;
   int SpeedTempValue2;
   int LookupFlag;


  // int PWM_Width[5];

   float CapVol[10]={0};
   float TempCapVol=0;
   float CapVoltage=0;

   float TempValue;
   float VectorLength;      //Vector length in svm
   float VectorAngle;		//Vector angle in svm
   float Theta;			    //Angle used in t0-t4 calculation, one sector
   float RotorPosInit;
   float Vdss;
   float Vqss;
   float RotorSpd;
  // float Vdse;
  // float Vqse;       
   float T1_DutyRatio;
   float T0_DutyRatio; 
  
  // variables for 3 level 3 phase

  int  T0, T1, T2, T3, T4;	//Duration time for five voltage vectors
  int  Region;
  int  TempState;
 

  float LengthA;// Length A and B and C is the 0 degree direction length of the sector one 
  float LengthB;           
  float LengthC;

  float ProjectionLengthK1;
  float ProjectionLengthK2;
  float ProjectionLengthK3;
  float ProjectionLengthL1;
  float ProjectionLengthL2;
  float ProjectionLengthM1;
  float ProjectionLengthM2;

  float ProjectionLengthN1;
  float ProjectionLengthN2;
  float ProjectionLengthP1;
  float ProjectionLengthP2;

  float Vref_M;
  float Vref_L;
  float Vref_K;
  float Vref_N;
  float Vref_P;
  float VolVectorDss;
  float VolVectorQss;

// ----------d1-q1 variable for sliding-mode observer-------------

   float Idsso=0;
   float Iqsso=0;
   float Lamda_drso=0;
   float Lamda_qrso=0;
     
   float A[4][4]={{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
   float B[4][2]={{0,0},{0,0},{0,0},{0,0}};
   float I4[4][4]={{1,0,0,0},{0,1,0,0},{0,0,1,0},{0,0,0,1}};
   float Adk[4][4]={{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
   float Bdk[4][2]={{0,0},{0,0},{0,0},{0,0}};

//----------d3-q3 variable for SMO---------------------------------

   float Id3sso=0;
   float Iq3sso=0;
   float Lamda_d3rso=0;
   float Lamda_q3rso=0;
     
   float A_A[4][4]={{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
   float B_A[4][2]={{0,0},{0,0},{0,0},{0,0}};
   float Adk_A[4][4]={{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
   float Bdk_A[4][2]={{0,0},{0,0},{0,0},{0,0}};


//--------------------------------------------------------------------

  unsigned int SectorNum_F=0;
  unsigned int SectorNum_A=0;
  unsigned int SwitchingPos=0;
  unsigned int SwitchStateA=0;
  unsigned int SwitchStateB=0;
  unsigned int SwitchStateC=0;
  unsigned int SwitchStateD=0;
  unsigned int SwitchStateE=0;

  signed int phi=0;
  signed int Tor=0;
  signed int BemfLevel;
  float BEMF;
  float Vd1ss; 
  float Vq1ss;
  float Vd3ss;
  float Vq3ss;

 
typedef struct

{
  	volatile uword* LTCupON;
  	volatile uword* LTCupOFF;
  	volatile uword* LTCdownON;
  	volatile uword* LTCdownOFF;
   //	unsigned DeadBand;
   //	uword modulation;
} PWMPair_2level;

PWMPair_2level PWM_2level[MAX_PWM_CHANNELS]; 

typedef struct
{
  	volatile uword* LTCQ1ON;
  	volatile uword* LTCQ1OFF;
  	volatile uword* LTCQ2ON;
  	volatile uword* LTCQ2OFF;
  	volatile uword* LTCQ3ON;
  	volatile uword* LTCQ3OFF;
  	volatile uword* LTCQ4ON;
  	volatile uword* LTCQ4OFF;
  	unsigned underlap;
 } PWMPair;

PWMPair PWM[MAX_PWM_CHANNELS];

void InitPWM(void)
{
  PWM[0].LTCQ1ON = &GPTA0_LTCXR02 ;
  PWM[0].LTCQ1OFF = &GPTA0_LTCXR03 ;
  PWM[0].LTCQ2ON = &GPTA0_LTCXR04 ;
  PWM[0].LTCQ2OFF = &GPTA0_LTCXR05 ;
  PWM[0].LTCQ3ON = &GPTA0_LTCXR06 ;
  PWM[0].LTCQ3OFF = &GPTA0_LTCXR07 ;
  PWM[0].LTCQ4ON = &GPTA0_LTCXR08 ;
  PWM[0].LTCQ4OFF = &GPTA0_LTCXR09 ;
 
  PWM[1].LTCQ1ON = &GPTA0_LTCXR10 ;
  PWM[1].LTCQ1OFF = &GPTA0_LTCXR11 ;
  PWM[1].LTCQ2ON = &GPTA0_LTCXR12 ;
  PWM[1].LTCQ2OFF = &GPTA0_LTCXR13 ;
  PWM[1].LTCQ3ON = &GPTA0_LTCXR14 ;
  PWM[1].LTCQ3OFF = &GPTA0_LTCXR15 ;
  PWM[1].LTCQ4ON = &GPTA0_LTCXR16 ;
  PWM[1].LTCQ4OFF = &GPTA0_LTCXR17 ;
  
  PWM[2].LTCQ1ON = &GPTA0_LTCXR18 ;
  PWM[2].LTCQ1OFF = &GPTA0_LTCXR19 ;
  PWM[2].LTCQ2ON = &GPTA0_LTCXR20 ;
  PWM[2].LTCQ2OFF = &GPTA0_LTCXR21 ;
  PWM[2].LTCQ3ON = &GPTA0_LTCXR22 ;
  PWM[2].LTCQ3OFF = &GPTA0_LTCXR23 ;
  PWM[2].LTCQ4ON = &GPTA0_LTCXR24 ;
  PWM[2].LTCQ4OFF = &GPTA0_LTCXR25 ;
 
  PWM[3].LTCQ1ON = &GPTA0_LTCXR26 ;
  PWM[3].LTCQ1OFF = &GPTA0_LTCXR27 ;
  PWM[3].LTCQ2ON = &GPTA0_LTCXR32 ;
  PWM[3].LTCQ2OFF = &GPTA0_LTCXR33 ;
  PWM[3].LTCQ3ON = &GPTA0_LTCXR34 ;
  PWM[3].LTCQ3OFF = &GPTA0_LTCXR35 ;
  PWM[3].LTCQ4ON = &GPTA0_LTCXR36 ;
  PWM[3].LTCQ4OFF = &GPTA0_LTCXR37 ;
 
  PWM[4].LTCQ1ON = &GPTA0_LTCXR38 ;
  PWM[4].LTCQ1OFF = &GPTA0_LTCXR39 ;
  PWM[4].LTCQ2ON = &GPTA0_LTCXR40 ;
  PWM[4].LTCQ2OFF = &GPTA0_LTCXR41 ;
  PWM[4].LTCQ3ON = &GPTA0_LTCXR42 ;
  PWM[4].LTCQ3OFF = &GPTA0_LTCXR43 ;
  PWM[4].LTCQ4ON = &GPTA0_LTCXR44 ;
  PWM[4].LTCQ4OFF = &GPTA0_LTCXR45 ;
 

}

void InitPWM_2level(void)
{
  PWM_2level[0].LTCupON = &GPTA0_LTCXR02 ;
  PWM_2level[0].LTCupOFF = &GPTA0_LTCXR03 ;
  PWM_2level[0].LTCdownON = &GPTA0_LTCXR04 ;
  PWM_2level[0].LTCdownOFF = &GPTA0_LTCXR05 ;
  //PWM[0].underlap = DeadBand ;

  PWM_2level[1].LTCupON = &GPTA0_LTCXR06 ;
  PWM_2level[1].LTCupOFF = &GPTA0_LTCXR07 ;
  PWM_2level[1].LTCdownON = &GPTA0_LTCXR08 ;
  PWM_2level[1].LTCdownOFF = &GPTA0_LTCXR09 ;
 // PWM[1].underlap = DeadBand ;

  PWM_2level[2].LTCupON = &GPTA0_LTCXR10 ;
  PWM_2level[2].LTCupOFF = &GPTA0_LTCXR11 ;
  PWM_2level[2].LTCdownON = &GPTA0_LTCXR12 ;
  PWM_2level[2].LTCdownOFF = &GPTA0_LTCXR13 ;
  //PWM[2].underlap = DeadBand ;

  PWM_2level[3].LTCupON = &GPTA0_LTCXR14 ;
  PWM_2level[3].LTCupOFF = &GPTA0_LTCXR15 ;
  PWM_2level[3].LTCdownON = &GPTA0_LTCXR16 ;
  PWM_2level[3].LTCdownOFF = &GPTA0_LTCXR17 ;
 // PWM[3].underlap = DeadBand ;

  PWM_2level[4].LTCupON = &GPTA0_LTCXR18 ;
  PWM_2level[4].LTCupOFF = &GPTA0_LTCXR19 ;
  PWM_2level[4].LTCdownON = &GPTA0_LTCXR20 ;	  
  PWM_2level[4].LTCdownOFF = &GPTA0_LTCXR21 ;

}



int SetPwmModulation(ushort Channel, unsigned int IGBT_State,unsigned int SetTimer, unsigned int ResetTimer)
{						
  if(Channel >= MAX_PWM_CHANNELS )
    return -1;
  else
    {
   	  	  if(IGBT_State==1)
	    {

            *(PWM[Channel].LTCQ1ON) =SetTimer;
          	*(PWM[Channel].LTCQ1OFF) =ResetTimer;
           	*(PWM[Channel].LTCQ3OFF) = *(PWM[Channel].LTCQ1ON)-DeadBand;
	  	    *(PWM[Channel].LTCQ3ON) = *(PWM[Channel].LTCQ1OFF)+DeadBand;
	  	    *(PWM[Channel].LTCQ2OFF) = (uword)100*SwitchPeriod;
	  	    *(PWM[Channel].LTCQ2ON) = (uword)SwitchPeriod*0.07;
	  	    *(PWM[Channel].LTCQ4OFF) = (uword)SwitchPeriod*0.07;
	        *(PWM[Channel].LTCQ4ON) = (uword)100*SwitchPeriod;
    
   	    }
     if(IGBT_State==0)

	    {

        *(PWM[Channel].LTCQ2ON) =SetTimer;
	   	*(PWM[Channel].LTCQ2OFF) =ResetTimer;
        *(PWM[Channel].LTCQ4OFF) = *(PWM[Channel].LTCQ2ON)-DeadBand;
	   	*(PWM[Channel].LTCQ4ON) = *(PWM[Channel].LTCQ2OFF)+DeadBand;
	   	*(PWM[Channel].LTCQ1OFF) = (uword)0;
	   	*(PWM[Channel].LTCQ1ON) = (uword) 100*SwitchPeriod;
	   	*(PWM[Channel].LTCQ3OFF) = (uword)100*SwitchPeriod;
	   	*(PWM[Channel].LTCQ3ON) = (uword) 0; 

   	    }
	
      return 0;
      }
}

void ResetPWM (unsigned int PWM_Sig[])
{
//  PWM_Sig[0]=SwitchPeriod/2;
//  PWM_Sig[1]=SwitchPeriod/2;
//  PWM_Sig[2]=SwitchPeriod/2;
//  PWM_Sig[3]=SwitchPeriod/2;
//  PWM_Sig[4]=SwitchPeriod/2; 

}
 
// ****** the following fuction is to use main vector space to generate PWM ***
 
int PWMWidth_Cal(int temp1,float DutyRatio, float Vdc,float Vdse, float Vqse, float RotorFluxAng,float Ia, float Ib,float Ic,float Id,float Ie,unsigned int SwitchState[], unsigned int PWM_Width[])
   {
   
    // **************** close loop algorithm****************  
    //Vdss=Vdse*cos(RotorFluxAng)-Vqse*sin(RotorFluxAng);
    //Vqss=Vdse*sin(RotorFluxAng)+Vqse*cos(RotorFluxAng);

   // ************** open loop algorithm *******************  
    //Vdss =Amplitude*sin (2* pi *(temp1)/100+pi/2);  // Modulation index =0.9 Vdss, Vqss=179.8;
    //Vqss=Amplitude*sin(2* pi *(temp1)/100); //  M=0.85, Vdss, Vqss=170; M=0.8, Vdss,Vqss=160
      
  Vdss=Vdse;
  Vqss=Vqse;
  VectorLength=sqrt(Vdss*Vdss+Vqss*Vqss); //	M=0.75, Vdss, Vqss=150;
  TempValue=Vdss/VectorLength;			   //Calculate vector angle in svm
   
  if (TempValue>=1)
  TempValue=1;
  if (TempValue<=-1)
  TempValue=-1;
  VectorAngle=acos(TempValue);             
  if (Vqss<0)
  VectorAngle=2*pi-VectorAngle;

  if (VectorAngle>=pi/5*9)	       //Determine sector number
  SectorNum=10;
  else if (VectorAngle>=pi/5*8)
  SectorNum=9;
  else if (VectorAngle>=pi/5*7)
  SectorNum=8;
  else if (VectorAngle>=pi/5*6)
  SectorNum=7;
  else if (VectorAngle>=pi)
  SectorNum=6;
  else if (VectorAngle>=pi/5*4)
  SectorNum=5;
  else if (VectorAngle>=pi/5*3)
  SectorNum=4;
  else if (VectorAngle>=pi/5*2)
  SectorNum=3;
  else if (VectorAngle>=pi/5*1)
  SectorNum=2;
  else
  SectorNum=1;
  		                                     	 
   Theta=VectorAngle-pi/5*(SectorNum-1);
   VolVectorDss=VectorLength/Vdc*cos(Theta)*SwitchPeriod;
   VolVectorQss=VectorLength/Vdc*sin(Theta)*SwitchPeriod;
                  
//---------------------Region Recognization and applying time calculation--------
  //  ProjectionLengthK1=LengthA*cos(pi/10);


    LengthA =Vdc*(1+K*K)/(5*(1+K)); // Length A and B and C is the 0 degree direction length of the sector one 
    LengthB = LengthA*(1+1/K);           
    LengthC = LengthA*(1+1/K+1/(K*K));

    ProjectionLengthK1 = LengthA*cos(pi/10);
    ProjectionLengthK2 = LengthB*cos(pi/10);
    ProjectionLengthK3 = LengthC*cos(pi/10);

    ProjectionLengthL1 = LengthA*cos(pi/10);
    ProjectionLengthL2 = LengthB*cos(pi/10);
    ProjectionLengthM1 = LengthA*sin(pi/5);
    ProjectionLengthM2 = LengthB*sin(pi/5);

    ProjectionLengthN1 = LengthA*cos(pi/10);
    ProjectionLengthN2 = LengthB*cos(pi/10);
    ProjectionLengthP1 = LengthA*sin(pi/5);
    ProjectionLengthP2 = LengthB*sin(pi/5);

   
    Vref_M=VectorLength*cos(pi/2-Theta);
    Vref_L=VectorLength*cos(3*pi/10-Theta);
    Vref_K=VectorLength*cos(Theta-pi/10);
    Vref_N=VectorLength*cos(Theta+pi/10);
    Vref_P=VectorLength*cos(Theta+3*pi/10);
                   
                   
   	if (Vref_K<ProjectionLengthK1)

     {
     T0=2*Factor_K4*VolVectorQss;
     T1=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T2=2*Factor_K2*VolVectorQss;
     T3=SwitchPeriod-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T4=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     Region=1;
     }
    
                   
     if ((Vref_K>=ProjectionLengthK1)&&(Vref_N<ProjectionLengthN1)&&( Vref_L<ProjectionLengthL1))
	 {
     T0=2*Factor_K4*VolVectorQss;
     T1=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T2=SwitchPeriod-Factor_K1*VolVectorDss+Factor_K2*VolVectorQss;
     T3=Factor_K1*VolVectorDss+Factor_K2*VolVectorQss-SwitchPeriod;
     T4=SwitchPeriod-Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     Region=2;
     }
                   
     if ((Vref_K>=ProjectionLengthK1)&&(Vref_N>=ProjectionLengthN1)&&( Vref_L<ProjectionLengthL1))    
     {
     T0=2*Factor_K4*VolVectorQss;
     T1=SwitchPeriod-Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K1*VolVectorDss-Factor_K2*VolVectorQss-SwitchPeriod;
     T3=2*Factor_K2*VolVectorQss;
     T4=SwitchPeriod-Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     Region=3;
     }                   
     if ((Vref_K>=ProjectionLengthK1)&&(Vref_K<ProjectionLengthK2)&&(Vref_N<ProjectionLengthN1)&&( Vref_L>=ProjectionLengthL1))
     {
     T0=SwitchPeriod-Factor_K5*VolVectorDss+Factor_K7*VolVectorQss;
     T1=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T2=SwitchPeriod-Factor_K1*VolVectorDss+Factor_K2*VolVectorQss;
     T3=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T4=Factor_K5*VolVectorDss+Factor_K6*VolVectorQss-SwitchPeriod;
     Region=4;
     }

     if ((Vref_K>=ProjectionLengthK1)&&(Vref_K<ProjectionLengthK2)&&(Vref_N>=ProjectionLengthN1)&&( Vref_L>=ProjectionLengthL1))
     {
     T0=SwitchPeriod-Factor_K5*VolVectorDss+Factor_K7*VolVectorQss;
     T1=SwitchPeriod-Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K1*VolVectorDss-Factor_K2*VolVectorQss-SwitchPeriod;
     T3=SwitchPeriod-Factor_K5*VolVectorDss-Factor_K7*VolVectorQss;
     T4=Factor_K5*VolVectorDss+Factor_K6*VolVectorQss-SwitchPeriod;
     Region=5;
     }
     if ((Vref_P>=ProjectionLengthP2)&&( Vref_K<= ProjectionLengthK3))
     {
     T0=2*SwitchPeriod-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=2*Factor_K4*VolVectorQss;
     T3=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss-SwitchPeriod;
     T4=2*Factor_K2*VolVectorQss;
     Region=6;
     }
     if ((Vref_P>=ProjectionLengthP1)&&(Vref_P<ProjectionLengthP2)&&(Vref_N>ProjectionLengthN2)&&( Vref_K<= ProjectionLengthK3))
     {
     T0=2*SwitchPeriod-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K5*VolVectorDss+Factor_K7*VolVectorQss-SwitchPeriod;
     T3=SwitchPeriod-Factor_K5*VolVectorDss+Factor_K6*VolVectorQss;
     T4=Factor_K5*VolVectorDss-Factor_K7*VolVectorQss-SwitchPeriod;
     Region=7;
     }
     if ((Vref_K>=ProjectionLengthK2)&&(Vref_K<ProjectionLengthK3)&&(Vref_N<ProjectionLengthN2)&&( Vref_L<ProjectionLengthL2))
     {
     T0=SwitchPeriod-Factor_K5*VolVectorDss+Factor_K7*VolVectorQss;
     T1=SwitchPeriod-Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T3=Factor_K5*VolVectorDss+Factor_K7*VolVectorQss-SwitchPeriod;
     T4=2*Factor_K2*VolVectorQss;
     Region=8;
     }
     if ((Vref_K>=ProjectionLengthK2)&&(Vref_K<ProjectionLengthK3)&&(Vref_M<ProjectionLengthM2)&&( Vref_L>=ProjectionLengthL2)&&(Vref_M>=ProjectionLengthM1))
     {
     T0=2*SwitchPeriod-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss+Factor_K4*VolVectorQss-SwitchPeriod;
     T2=SwitchPeriod-2*Factor_K4*VolVectorQss;
     T3=Factor_K5*VolVectorDss+Factor_K7*VolVectorQss-SwitchPeriod;
     T4=2*Factor_K2*VolVectorQss;
     Region=9;
     }

     if ((Vref_K>=ProjectionLengthK2)&&(Vref_K<ProjectionLengthK3)&&(Vref_M>=ProjectionLengthM2))
     {
     T0=2*SwitchPeriod-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=2*Factor_K4*VolVectorQss-SwitchPeriod;
     T3=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T4=2*Factor_K2*VolVectorQss;
     Region=10;
     } 
//--------------------------------------------------------------------
// calculate pulse width and swithing points for each phase
   if ( (SectorNum%2)==1)
   {
     if(Region==1)
	 {
       if(T0<T1)
	   {
	   
	   if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T0+T4+T1_DutyRatio;
       PWM_Width[1]=T0+T1_DutyRatio;
       PWM_Width[2]=T0+T2+T3+T4+T1_DutyRatio;
       PWM_Width[3]=T0+T3+T4+T1_DutyRatio;
       PWM_Width[4]=T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
	   }
      else
	   {

       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T4+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[3]=T3+T4+T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
       }
    }       
    if(Region==2)
	{
       if(T0>T1)
	   {
       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T3+T4+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[3]=T4+T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
	   }
       else
	   {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T3+T4+T0+T1_DutyRatio;
       PWM_Width[1]=T0+T1_DutyRatio;
       PWM_Width[2]=T2+T3+T4+T0+T1_DutyRatio;
       PWM_Width[3]=T4+T0+T1_DutyRatio;
       PWM_Width[4]=T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
       }
	}
    if(Region==3)
    {   
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T2+T3+T4+T0+T1_DutyRatio;
       PWM_Width[1]=T0+T1_DutyRatio;
       PWM_Width[2]=T3+T4+T0+T1_DutyRatio;
       PWM_Width[3]= T4+T0+T1_DutyRatio;
       PWM_Width[4]=T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
    }
       
    if(Region==4)
	{
       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T3+T4+T0_DutyRatio;
       PWM_Width[1]=T4+T0_DutyRatio;
       PWM_Width[2]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
    }
       
    if(Region==5)
	{
       if(T0>T1)
	   {
       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T4+T0_DutyRatio;
       PWM_Width[2]=T3+T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
	   }
       else
	   {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T2+T3+T4+T0+T1_DutyRatio;
       PWM_Width[1]=T4+T0+T1_DutyRatio;
       PWM_Width[2]=T3+T4+T0+T1_DutyRatio;
       PWM_Width[3]=T0+T1_DutyRatio;
       PWM_Width[4]=T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
       }
    }
       
     if(Region==6)
	 {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	   
       PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[2]=T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
     }
       
    if(Region==7)
	{
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	   
       PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[2]=T3+T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
    }
       
   if(Region==8)
   {

       if(T0>T1)
	   {
       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	  
       PWM_Width[0]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T3+T4+T0_DutyRatio;
       PWM_Width[2]=T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
	   }
       else
	   {
        if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
        T1_DutyRatio=(DutyRatio)*T1;
	    else
	    T1_DutyRatio=(1-DutyRatio)*T1;

        PWM_Width[0]=T2+T3+T4+T0+T1_DutyRatio;
        PWM_Width[1]=T3+T4+T0+T1_DutyRatio;
        PWM_Width[2]=T4+T0+T1_DutyRatio;
        PWM_Width[3]=T0+T1_DutyRatio;
        PWM_Width[4]=T1_DutyRatio;
        SwitchState[0]=1;
        SwitchState[1]=1;
        SwitchState[2]=0;
        SwitchState[3]=0;
        SwitchState[4]=1;
       }
    }
       
    if(Region==9)
	{
       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	   
	   PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T3+T4+T0_DutyRatio;
       PWM_Width[2]=T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T2+T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
    }
       
    if(Region==10)
	{
       if((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T2+T3+T4+T0_DutyRatio;
       PWM_Width[2]=T4+T0_DutyRatio;
       PWM_Width[3]=T0_DutyRatio;
       PWM_Width[4]=T3+T4+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=0;
    }

       PhaseShftNum=(SectorNum-1)/2;

  }
    else
	{
      if(Region==1)
	  {
       if(T0<T1)
	   {
       if((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T2+T1_DutyRatio;
       PWM_Width[1]=T4+T3+T2+T0+T1_DutyRatio;
       PWM_Width[2]=T2+T3+T1_DutyRatio;
       PWM_Width[3]=T2+T3+T4+T1_DutyRatio;
       PWM_Width[4]=T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
	   }
       else
	   {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T2+T1+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]=T2+T3+T1+T0_DutyRatio;
       PWM_Width[3]=T2+T3+T4+T1+T0_DutyRatio;
       PWM_Width[4]=T1+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
       }

     }
       
       
    if(Region==2)
	{
       if(T0<T1)
	   {
       if((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T2+T3+T1_DutyRatio;
       PWM_Width[1]=T0+T2+T3+T4+T1_DutyRatio;
       PWM_Width[2]= T2+T1_DutyRatio;
       PWM_Width[3]=T2+T3+T4+T1_DutyRatio;
       PWM_Width[4]=T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
	   }
       else
	   {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	  
	   PWM_Width[0]=T2+T3+ T1+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]= T2+T1+T0_DutyRatio;
       PWM_Width[3]=T2+T3+T4+T1+T0_DutyRatio;
       PWM_Width[4]=T1+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
       }

    }
       

    if(Region==3)
	{
       
       if((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;
	   
	     
       PWM_Width[0]=T3+T2+T1_DutyRatio;
       PWM_Width[1]=T0+T2+T3+T4+T1_DutyRatio;
       PWM_Width[2]=T1_DutyRatio;
       PWM_Width[3]=T3+T2+T4+T1_DutyRatio;
       PWM_Width[4]=T2+T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
     }
       
    if(Region==4)
	{  
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T4+T3+T2+T1+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]=T2+T1+T0_DutyRatio;
       PWM_Width[3]=T2+T3+T1+T0_DutyRatio;
       PWM_Width[4]=T1+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
    }
       
    if(Region==5)
	{
       if(T1>T0)
	   {
       if((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;
	     
       PWM_Width[0]=T2+T3+T4+T1_DutyRatio;
       PWM_Width[1]=T0+T2+T3+T4+T1_DutyRatio;
       PWM_Width[2]=T1_DutyRatio;
       PWM_Width[3]=T3+T2+T1_DutyRatio;
       PWM_Width[4]=T2+T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
	   }
       else
	   {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	    
       PWM_Width[0]=T2+T3+T4+T1+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]=T1+T0_DutyRatio;
       PWM_Width[3]=T3+T2+T1+T0_DutyRatio;
       PWM_Width[4]=T2+T1+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
       }
     }
       
    if(Region==6)
	{
       if((Ia>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	   
	   PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T1+T2+T0_DutyRatio;
       PWM_Width[2]=T0_DutyRatio;
       PWM_Width[3]=T1+T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
     }
       
     if(Region==7)
	 {
       if((Ia>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	     
       PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T1+T2+T3+T0_DutyRatio;
       PWM_Width[2]=T0_DutyRatio;
       PWM_Width[3]=T1+T0_DutyRatio;
       PWM_Width[4]=T1+T2+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
     }
       
    if(Region==8)
	{

       if(T1>T0)
	   {
       if((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
	   else
	   T1_DutyRatio=(1-DutyRatio)*T1;

       PWM_Width[0]=T4+T2+T3+T1_DutyRatio;
       PWM_Width[1]=T0+T2+T3+T4+T1_DutyRatio;
       PWM_Width[2]=T1_DutyRatio;
       PWM_Width[3]=T2+T1_DutyRatio;
       PWM_Width[4]=T2+T3+T1_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=0;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
	   }
       else
	   {
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T4+T2+T3+T1+T0_DutyRatio;
       PWM_Width[1]=T0_DutyRatio;
       PWM_Width[2]=T1+T0_DutyRatio;
       PWM_Width[3]=T2+T1+T0_DutyRatio;
       PWM_Width[4]=T2+T3+T1+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
       }
     }
       
    if(Region==9)
	{
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;

       PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T1+T0_DutyRatio;
       PWM_Width[2]=T0_DutyRatio;
       PWM_Width[3]=T1+T2+T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
    }
       
    if(Region==10)
	{
       if((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
	   else
	   T0_DutyRatio=(1-DutyRatio)*T0;
	    
       PWM_Width[0]=T1+T2+T3+T4+T0_DutyRatio;
       PWM_Width[1]=T1+T2+T0_DutyRatio;
       PWM_Width[2]=T0_DutyRatio;
       PWM_Width[3]=T1+T0_DutyRatio;
       PWM_Width[4]=T1+T2+T3+T0_DutyRatio;
       SwitchState[0]=1;
       SwitchState[1]=1;
       SwitchState[2]=0;
       SwitchState[3]=0;
       SwitchState[4]=1;
     }  
    PhaseShftNum=SectorNum/2;
    PhaseShftNum=PhaseShftNum%5;	
    }
    
     for (int i=1;i<=PhaseShftNum;i++)

    {
       tempi1=PWM_Width[4];
       PWM_Width[4]=PWM_Width[3];
       PWM_Width[3]=PWM_Width[2];
       PWM_Width[2]=PWM_Width[1];
       PWM_Width[1]=PWM_Width[0];
       PWM_Width[0]=tempi1;
       
       TempState=SwitchState[4];
       SwitchState[4]=SwitchState[3];
       SwitchState[3]=SwitchState[2];
       SwitchState[2]=SwitchState[1];
       SwitchState[1]=SwitchState[0];
       SwitchState[0]=TempState;
       
     }
     
   return Region;   
 

  }
//
  void PWMWidthLimitation(float Ia, float Ib, float Ic, float Id, float Ie,unsigned int OriginalPWMWidth[], unsigned int SetTimer[], unsigned int ResetTimer[])

{
    
  
	  for (int i=0;i<5;i++)
	  {
   	     if (OriginalPWMWidth[i]<2*DeadBand)
  	     OriginalPWMWidth[i]=2*DeadBand;
   	     if (OriginalPWMWidth[i]>=SwitchPeriod-2*DeadBand)
   	     OriginalPWMWidth[i]=SwitchPeriod-2*DeadBand;

	     SetTimer[i]=(SwitchPeriod-OriginalPWMWidth[i])/2;
	     ResetTimer[i]=(SwitchPeriod+OriginalPWMWidth[i])/2;
//
         if ((SetTimer[i]+ResetTimer[i])!=SwitchPeriod)
	     {
	 	  SetTimer[i]=SwitchPeriod-ResetTimer[i]; 
	 	  }

          if ((ResetTimer[i]-SetTimer[i])<DeadBand)
	      {
		  SetTimer[i]=0.5*( SetTimer[i]+ ResetTimer[i]-DeadBand);
		  ResetTimer[i]=SetTimer[i]+DeadBand;
		  }
          if (SetTimer[i]<(2*DeadBand+InitialBand))
	      {
	   	  SetTimer[i]=2*DeadBand+InitialBand;
		  ResetTimer[i]=SwitchPeriod-2*DeadBand;
	      }

         if ((ResetTimer[i]+2*DeadBand)>SwitchPeriod)
	     {
	  	   ResetTimer[i]=SwitchPeriod-2*DeadBand;
	  	   SetTimer[i]= 2*DeadBand+InitialBand;	  
	     }

       SetTimer0=OriginalPWMWidth[i];

      }
}
   

  void ADC0_Wait(void) 
{
  for(int i=0;i<25;i++)
  tempi1_1=0;
  
  while ((ADC0_STAT&0x00008000)==0x00008000)
  tempi1_1=0;
 }

void delay (void)
{
 for (int i=0; i<50; i++)
   tempi1_1=0;
}

void DagitAnalogConversion (unsigned short int OutputChannel,unsigned short int DigtalData)
{

   DataOutput= 0x00001000 + DigtalData; // 
   P1_OUT=DataOutput; // assign data on pin1; pin P1.15 as the dataoutput pin
   for (int i=0; i<16; i++)
	{
    IO_vResetPin(IO_P9_1);	// SCLK falling edge
   	delay();
	IO_vSetPin(IO_P9_1);	// SCLK rising edge
    P1_OUT=P1_OUT<<1;
     }   
    IO_vSetPin(IO_P9_0); 
}

float SpeedCalculation (int RotorPos, int RotorPosPre)
 {

  SpeedTempValue1=RotorPos-RotorPosPre;
  SpeedTempValue2=RotorPos-RotorPosPre+1024;
  if (abs(SpeedTempValue1)>abs(SpeedTempValue2))
  SpeedTempValue1=SpeedTempValue2;
  SpeedTempValue2=RotorPos-RotorPosPre-1024;
  if (abs(SpeedTempValue1)>abs(SpeedTempValue2))
  SpeedTempValue1=SpeedTempValue2; 
  RotorSpd=(SpeedTempValue1*2*pi/1024/0.006);     // the unit of motors peed is rad/s
 // RotorSpd_1=34;
       					
//  SpeedErr= 314/2-RotorSpd;	       //Speed loop PI regulation
//  //SpeedErr=RotorSpd;
//  SpeedErrSt=SpeedErrSt+SpeedErr*Kispd; 
//  if (SpeedErrSt>SpeedErrStmax)        //Limit speed error integration
//  SpeedErrSt=SpeedErrStmax;
//  if (SpeedErrSt<SpeedErrStmin)
//  SpeedErrSt=SpeedErrStmin;
//
//  IqseRef=SpeedErrSt+SpeedErr*Kpspd;   //Output torque current ref
//  if (IqseRef>Iqsemax)		           //Limit torque current ref	
//  IqseRef=Iqsemax;
//  if (IqseRef<Iqsemin)
//  IqseRef=Iqsemin;

return RotorSpd;

 }

//float RotorFluxAngleCal(int RotorPos, int RotorPosInit,float SlipRingAng)
//{
////******************************************************************************
////Calculate rotor flux position
////****************************************************************************** 
//
//  TempFluxAngle=RotorPos-RotorPosInit;
//  TempFluxAngle=TempFluxAngle/1024*2*pi;
//  RotorFluxAng=TempFluxAngle+SlipRingAng;
//  									   //Limit RotorFluxAngle in 0-2*pi
//  RotorFluxAng=fmod(RotorFluxAng, 2*pi);
//  //RotorFluxAng=pi/4;
//
//  if (RotorFluxAng<0)
//  RotorFluxAng=RotorFluxAng+2*pi;
//
// // Idqse[0]= Idss*cos(RotorFluxAng)+Iqss*sin(RotorFluxAng);
// // Idqse[1]=-Idss*sin(RotorFluxAng)+Iqss*cos(RotorFluxAng);
//     
//  return RotorFluxAng;
//
// }

// float RotorFluxSlipAngleCal(float Idse,float Iqse, float RotorFluxAng, float StatorFluxPara[])
// {
// 
// RotorFluxMag=RotorFluxMag+(Lm1*Idse-RotorFluxMag)*Ts/Tr1; 
//				                       //Flux magnitude update
//  if (RotorFluxMag==0)                 //RotorFluxMag can not be zero
//  RotorFluxMag=1e-6;                   //in slip calculation
//
//  SlipSpd=Lm1/RotorFluxMag/Tr1*Iqse;         //Slip speed calculation
//  RFluxSlipAng=RFluxSlipAng+SlipSpd*Ts;    //Flux slip angle update
//                                       //Limit RFluxSlipAng with fmod 0-2*pi
//  RFluxSlipAng=fmod(RFluxSlipAng, 2*pi); 
//  if (RFluxSlipAng<0)                                    
//  RFluxSlipAng=RFluxSlipAng+2*pi;
//    
//  return RFluxSlipAng;
// }

//void PI_Controller(int SpdCNT,float SpdRef,float Vdc, float RotorSpd, float Idse,float Iqse, float Vdqse[])
//{
//	     if (SpdCNT==0)
//	     { 
//	     //SpeedErr= SpdRef-RotorSpd;//Speed loop PI regulation
//		  Upispd=SpeedErrSt+Kpspd*SpeedErr;   
//          TorqueRef=Upispd;         //Integration Correction
//          if (Upispd>Torquemax)
//          TorqueRef=Torquemax;
//          if (Upispd<Torquemin)
//          TorqueRef=Torquemin; 
//          SpeedErrSt=SpeedErrSt+Kispd*SpeedErr+Kcorspd*(TorqueRef-Upispd);
//	  	 }
//
//
//		  IdseErr=IdseRef-Idse;
//		  IqseErr=IqseRef-Iqse;
//		  
//		  IdseErrSt=IdseErrSt+IdseErr*Kicur;   
//		  if (IdseErrSt>IdseErrStmax)	       //Limit Idse error integration
//		  IdseErrSt=IdseErrStmax;
//		  if (IdseErrSt<IdseErrStmin)
//		  IdseErrSt=IdseErrStmin;
//		  
//		  IqseErrSt=IqseErrSt+IqseErr*Kicur;
//		  if (IqseErrSt>IqseErrStmax)
//		  IqseErrSt=IqseErrStmax;
//		  if (IqseErrSt<IqseErrStmin)
//		  IqseErrSt=IqseErrStmin;
//		  
//		  Vdqse[0]=IdseErrSt+IdseErr*Kpcur;        //Calculate and limit Vdse
//		  if (Vdqse[0]>Vdsemax)
//		  Vdqse[0]=Vdsemax;
//		  if (Vdqse[0]<Vdsemin)
//		  Vdqse[0]=Vdsemin;
//
//		  Vqsemax=sqrt(Vdsemax*Vdsemax-Vdqse[0]*Vdqse[0]);      
//		  Vqsemin=-Vqsemax;		               //Calculate the limit value for Vqse  		  
//		  		  
//		  Vdqse[1]=IqseErrSt+IqseErr*Kpcur;        //Calculate and limit Vqse
//		  if (Vdqse[1]>Vqsemax)
//		  Vdqse[1]=Vqsemax;
//		  if (Vdqse[1]<Vqsemin)
//		  Vdqse[1]=Vqsemin;
//}
//
void AnalogToDigitConversion(int OffSet[7])
{
   ADC0_vStartConversion(0x00000020);   //PhaseC  Channel 5   AIN21
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_5, Result, Source);
   OffSet[0]=Result;

   ADC0_vStartConversion(0x00000040);   //PhaseD  Channel 6   AIN22
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_6, Result, Source);
   OffSet[1]=Result;

   ADC0_vStartConversion(0x00000080);   //PhaseE  Channel 7	  AIN20
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_7, Result, Source);
   OffSet[2]=Result;

   ADC0_vStartConversion(0x00000100);   //PhaseA  Channel 8  AIN24
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_8, Result, Source);
   OffSet[3]=Result;

   ADC0_vStartConversion(0x00000800);   //PhaseB  Channel 11  AIN27
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_11, Result, Source);
   OffSet[4]=Result;

   ADC0_vStartConversion(0x00001000);   // Voltage measure Vdc  Channel 12  AIN28
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_12, Result, Source);
   OffSet[5]= Result;
   
   ADC0_vStartConversion(0x00002000);   //Voltage measure Upper Capacitor  Channel 13  AIN29
   ADC0_Wait();
   ADC0_vGetConversionResult(ADC0_CHANNEL_13, Result, Source);
   OffSet[6]=Result;

 //  ADC0_vStartConversion(0x00004000);   //Voltage measure PhaseB  Channel 14  AIN30
 //  ADC0_Wait();
 //  ADC0_vGetConversionResult(ADC0_CHANNEL_14, Result, Source);
 //  OffSet[7]=Result;

}

//	float DCLinkMeasurement( int ActualCapVol)
//	{
//
//	  for (  int j=0; j<=10; j++)
//		{
//	    CapVol[j+1]=CapVol[j];
//	   	}
//	    CapVol[0]=(ActualCapVol)*0.04884;
//	    
//
//	    for (int  i=0; i<=10; i++)
//	    {        
//	    TempCapVol=TempCapVol+CapVol[i];
//	   	}
//	    CapVoltage=TempCapVol/10.0;
//	  		     
//	  
//	   return CapVoltage;
//
//	}
 void SlidingModeFluxObserver(float RotorSpeed,float Idss, float Iqss, float Vdss, float Vqss, float CurrentAndFlux[4])

{
   //----------------------------------------------------------------------------
   float k3[1][2];  
   float k4[1][2];
   float L[2][2];
     
   float Vk[2][1];
   float Xk[4][1];
   float Xk1[4][1];


   int Sign_s1, Sign_s2;
   
   float s1, s2;
//----------------------------------------------------------------------------     					
   
   float tempf3;
   float tempf1;
   float tempf2;

   unsigned int m, n, i;
   float ai12, ai22;

  tempf3=Rr1*Rr1+RotorSpeed*Lr1*RotorSpeed*Lr1;	 
  tempf1=-Q1*Ls1*Lr1/Lm1*(1+(-15)*Rr1*Lr1/tempf3);
  tempf2= Q1*Ls1*Lr1/Lm1*(-15)*RotorSpeed*Lr1*Lr1/tempf3;
 
//  tempf3=0.1764+RotorSpeed*RotorSpeed*0.01142761;	   //Gain calculation
//  tempf1=-0.005880824*(1-0.67347/tempf3);
//  tempf2= 0.005880824*(-0.17141415*RotorSpeed/tempf3);

  L[0][0]= tempf1; L[0][1]=tempf2;
  L[1][0]=-tempf2; L[1][1]=tempf1;

  k3[0][0]=k1*L[0][0]; k3[0][1]=k2*L[0][1];
  k4[0][0]=k1*L[1][0]; k4[0][1]=k2*L[1][1];

//----------------------------------------------------------------------------
  ai12=-Lm1/(Q1*Ls1*Lr1)*RotorSpeed;	 //Discrete model update
//   ai12=-126.47*RotorSpeed;	 //Discrete model update

  ai22=RotorSpeed;	       
  A[0][3]=-ai12; A[1][2]=ai12;    	    
  A[2][3]=-ai22; A[3][2]=ai22; 

//----------------------------------------------------------------------------
  for (m=0;m<=3;m++)                   //Adk=I4+A*Ts
  { 						           //Bdk=Ts*B
  for (n=0;n<=3;n++)
  {
  Adk[m][n]=I4[m][n]+A[m][n]*Ts;
  }
  }	
//----------------------------------------------------------------------------
  Xk[0][0]=Idsso; Xk[2][0]=Lamda_drso;
  Xk[1][0]=Iqsso; Xk[3][0]=Lamda_qrso;
  Vk[0][0]=Vdss; Vk[1][0]=Vqss;

//----------------------------------------------------------------------------  
  for (m=0;m<=3;m++)		           //Xk+1=Adk*Xk+Bdk*Vk
  {
  Xk1[m][0]=0;

  for (i=0;i<=3;i++)
  Xk1[m][0]=Xk1[m][0]+Adk[m][i]*Xk[i][0];

  for (i=0;i<=1;i++)
  Xk1[m][0]=Xk1[m][0]+Bdk[m][i]*Vk[i][0];
  }
//----------------------------------------------------------------------------
  Idsso=Xk1[0][0]; Lamda_drso=Xk1[2][0];
  Iqsso=Xk1[1][0]; Lamda_qrso=Xk1[3][0];

//----------------------------------------------------------------------------
  s1=Idss-Idsso; s2=Iqss-Iqsso;        //Model compensation 
  
  if      (s1>0)  Sign_s1=1;
  else if (s1<0)  Sign_s1=-1;
  else            Sign_s1=0;

  if      (s2>0)  Sign_s2=1;
  else if (s2<0)  Sign_s2=-1;
  else            Sign_s2=0;
    
  Idsso=Idsso+Ts*k1*Sign_s1;
  Iqsso=Iqsso+Ts*k2*Sign_s2;
 // Idsso=Idsso+0.04*Sign_s1;
 // Iqsso=Iqsso+0.04*Sign_s2;

  Lamda_drso=Lamda_drso+Ts*(k3[0][0]*Sign_s1+k3[0][1]*Sign_s2);
  Lamda_qrso=Lamda_qrso+Ts*(k4[0][0]*Sign_s1+k4[0][1]*Sign_s2);
  CurrentAndFlux[0]=Idsso;
  CurrentAndFlux[1]=Iqsso;
  CurrentAndFlux[2]=Lamda_drso;
  CurrentAndFlux[3]=Lamda_qrso;
    
}

int ClassicDTCPwmModulation(ushort Channel, unsigned int IGBT_State, float PhaseCurrent)
{
   if(Channel >= MAX_PWM_CHANNELS )
    return -1;

  else
    {
	 // if(PhaseCurrent>=0)
	 // {
///----------------------------the following PWM is working,but need improvement---------
//        if(IGBT_State==2)
//	    {
//			 
//            *(PWM[Channel].LTCQ1ON) =DeadBand+InitialBand;
//          	*(PWM[Channel].LTCQ1OFF) =SwitchPeriod-DeadBand;
//           	*(PWM[Channel].LTCQ3OFF) =0+InitialBand;
//            *(PWM[Channel].LTCQ3ON) = SwitchPeriod+1000;
//	  	    *(PWM[Channel].LTCQ2OFF) = (uword)100*SwitchPeriod;
//	  	    *(PWM[Channel].LTCQ2ON) =0+InitialBand;
//	  	    *(PWM[Channel].LTCQ4OFF) =0+InitialBand;
//	        *(PWM[Channel].LTCQ4ON) = (uword)100*SwitchPeriod;
//    
//   	    }
//      if(IGBT_State==1 )
//
//	    {
//        *(PWM[Channel].LTCQ2ON) =DeadBand+InitialBand;
//        *(PWM[Channel].LTCQ2OFF) =SwitchPeriod-DeadBand;;
//        *(PWM[Channel].LTCQ4OFF) =0+InitialBand;
//	   	*(PWM[Channel].LTCQ4ON) = SwitchPeriod+1000;
//	   	*(PWM[Channel].LTCQ1OFF) = 0+InitialBand;
//	   	*(PWM[Channel].LTCQ1ON) = (uword) 100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3OFF) = (uword)100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3ON) = 0+InitialBand;
//   	    }
//	  if(IGBT_State==0 )
//
//	    {
//		  
//        *(PWM[Channel].LTCQ2ON) =SwitchPeriod+1000;
//	   	*(PWM[Channel].LTCQ2OFF) =0+InitialBand;
//        *(PWM[Channel].LTCQ4OFF) =SwitchPeriod-DeadBand;
//	   	*(PWM[Channel].LTCQ4ON) = DeadBand+InitialBand;
//	   	*(PWM[Channel].LTCQ1OFF) = 0+InitialBand;
//	   	*(PWM[Channel].LTCQ1ON) = (uword) 100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3OFF) = (uword)100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3ON) = 0+InitialBand; 
//
//   	    }

	   if(IGBT_State==2)
	    {
			 
            *(PWM[Channel].LTCQ1ON) =SwitchPeriod-T_temp;
          	*(PWM[Channel].LTCQ1OFF) =SwitchPeriod+1000;
           	*(PWM[Channel].LTCQ3OFF) =SwitchPeriod-T_temp-DeadBand;
            *(PWM[Channel].LTCQ3ON) = SwitchPeriod+1000;
	  	    *(PWM[Channel].LTCQ2OFF) =(uword)100*SwitchPeriod;
	  	    *(PWM[Channel].LTCQ2ON) =SwitchPeriod-5*T_temp;   //1000;
	  	    *(PWM[Channel].LTCQ4OFF) =SwitchPeriod-5*T_temp-DeadBand; //1000;
	        *(PWM[Channel].LTCQ4ON) =(uword)100*SwitchPeriod;
    
   	    }
      if(IGBT_State==1 )

	    {
		  
       
        *(PWM[Channel].LTCQ2ON) =SwitchPeriod-T_temp;
        *(PWM[Channel].LTCQ2OFF) =SwitchPeriod+1000;
        *(PWM[Channel].LTCQ4OFF) =SwitchPeriod-T_temp-DeadBand;
	   	*(PWM[Channel].LTCQ4ON) = SwitchPeriod+1000;
	   	*(PWM[Channel].LTCQ1OFF) =SwitchPeriod-5*T_temp-DeadBand; //(uword)1000;
	   	*(PWM[Channel].LTCQ1ON) =(uword) 100*SwitchPeriod;
	   	*(PWM[Channel].LTCQ3OFF) =(uword)100*SwitchPeriod;
	   	*(PWM[Channel].LTCQ3ON) =SwitchPeriod-5*T_temp;  //(uword) 1000; 

   	    }
	  if(IGBT_State==0 )

	    {
		  
        *(PWM[Channel].LTCQ2ON) =SwitchPeriod+1000;          //SwitchPeriod+1000;
	   	*(PWM[Channel].LTCQ2OFF) =SwitchPeriod-T_temp-DeadBand;          //T_temp;
        *(PWM[Channel].LTCQ4OFF) =SwitchPeriod+1000;      //SwitchPeriod+1000;
	   	*(PWM[Channel].LTCQ4ON) =SwitchPeriod-T_temp;      //T_temp+DeadBand;
	   	*(PWM[Channel].LTCQ1OFF) =SwitchPeriod-5*T_temp-DeadBand; //(uword)1000;
	   	*(PWM[Channel].LTCQ1ON) =(uword) 100*SwitchPeriod;
	   	*(PWM[Channel].LTCQ3OFF) =(uword)100*SwitchPeriod;
	   	*(PWM[Channel].LTCQ3ON) =SwitchPeriod-5*T_temp;  //(uword) 1000; 

   	    }
//  	}
//   if(PhaseCurrent<0)//	else
//	  {
//	  	if(IGBT_State==2)
//	    {
//		    
//		    *(PWM[Channel].LTCQ1ON) =T_temp+DeadBand;;
//          	*(PWM[Channel].LTCQ1OFF) =SwitchPeriod+1000;
//           	*(PWM[Channel].LTCQ3OFF) = T_temp;
//            *(PWM[Channel].LTCQ3ON) = SwitchPeriod+1000;
//	  	    *(PWM[Channel].LTCQ2OFF) =(uword)100*SwitchPeriod;
//	  	    *(PWM[Channel].LTCQ2ON) =SwitchPeriod-5*T_temp;   //1000;
//	  	    *(PWM[Channel].LTCQ4OFF) =SwitchPeriod-5*T_temp-DeadBand; //1000;
//	        *(PWM[Channel].LTCQ4ON) =(uword)100*SwitchPeriod;
//    
//    
//   	    }
//      if(IGBT_State==1 )
//
//	    {
//		        
//        *(PWM[Channel].LTCQ2ON) =T_temp+DeadBand;
//        *(PWM[Channel].LTCQ2OFF) =SwitchPeriod+1000;
//        *(PWM[Channel].LTCQ4OFF) =T_temp;
//	   	*(PWM[Channel].LTCQ4ON) = SwitchPeriod+1000;
//	   	*(PWM[Channel].LTCQ1OFF) =SwitchPeriod-5*T_temp-DeadBand; //(uword)1000;
//	   	*(PWM[Channel].LTCQ1ON) =(uword) 100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3OFF) =(uword)100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3ON) =SwitchPeriod-5*T_temp;  //(uword) 1000; 
//   	    }
//	  if(IGBT_State==0 )
//
//	    {
//
//      
//        *(PWM[Channel].LTCQ2ON) =SwitchPeriod+1000;          
//	   	*(PWM[Channel].LTCQ2OFF) =T_temp;                   
//        *(PWM[Channel].LTCQ4OFF) =SwitchPeriod+1000;        
//	   	*(PWM[Channel].LTCQ4ON) =T_temp+DeadBand;        
//	    *(PWM[Channel].LTCQ1OFF) =SwitchPeriod-5*T_temp-DeadBand; //(uword)1000;
//	   	*(PWM[Channel].LTCQ1ON) =(uword) 100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3OFF) =(uword)100*SwitchPeriod;
//	   	*(PWM[Channel].LTCQ3ON) =SwitchPeriod-5*T_temp;  //(uword) 1000; 
//
//   	    }
//  
//	  }
//

      return 0;
    }
}

void DTCLookUpTable (float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5])
{
   // float tempf;
	  
  //------------ in this function, the largest and second largest vectors are used
  //-------------to produce sinusoidals, there is no NP compensation-------------- 

    SectorNum_F=1;
    if (StatorFluxAng_F>(5.969026042))	 //19*pi/10
        SectorNum_F=1;    
    else if (StatorFluxAng_F>(5.340707511)) //17*pi/10
       SectorNum_F=10;
    else if (StatorFluxAng_F>(4.71238898))  //15*pi/10
       SectorNum_F=9 ; 
    else if (StatorFluxAng_F>(4.08407045))	//13*pi/10
       SectorNum_F=8;
    else if (StatorFluxAng_F>(3.455751919))	// 11*pi/10
       SectorNum_F=7;
    else if (StatorFluxAng_F>(2.827433388))	//9*pi/10
       SectorNum_F=6;
    else if (StatorFluxAng_F>(2.199114858))	// 7*pi/10
       SectorNum_F=5;
    else if (StatorFluxAng_F>(1.570796327))	//5*pi/10
       SectorNum_F=4;
    else if (StatorFluxAng_F>(0.942477796))		//3*pi/10
           SectorNum_F=3;
    else if (StatorFluxAng_F>(0.314159265))	   //pi/10
       SectorNum_F=2; 
    else
       SectorNum_F=1;

    
  //--------------------------Hysteresis band----------------------------------------
         phi=0;
      if (FlxErr+FluxBand<0)  
         phi=0;
  
      if (FlxErr-FluxBand>0)  
         phi=1;
  
        Tor=0;
      if (TorErr+TorqueBand<0)  
        Tor=-1;
  
      if (TorErr-TorqueBand>0) 
         Tor=1;
  
  //-----------------------------Back_Emf Calculation-----------------------
//    
//      BEMF=RotorSpeed*StatorFuxMagnitude;
//      tempf=0.17082039325*Vdc-1;    //%6; %28.6;  
//      BemfLevel=-1;
//      if (BEMF>tempf) BemfLevel=1;
//      else if (BEMF>-tempf) BemfLevel=0;
//      else BemfLevel=-1;
   
 // %------------------------------Space Vector Selection based on Bemf info----  
// if(BemfLevel==0) 
// {    
//  if (phi==1)
//    {
//    if (Tor==0)
//        SwitchingPos=10; 
//    if (Tor==1)
//        SwitchingPos=1;  
//    if (Tor==-1)
//        SwitchingPos=9; 
//    }
//
//  if (phi==0)
//    {
//    if (Tor==0)
//        SwitchingPos=10;
//    if (Tor==1)
//        SwitchingPos=4; 
//    if (Tor==-1)
//        SwitchingPos=6; 
//    }   
// } 
//
//
//if(BemfLevel==1)
//{  
//  if (phi==1)
//   {
//    if (Tor==0)
//        SwitchingPos=10; 
//    if (Tor==1)
//        SwitchingPos=2; 
//    if (Tor==-1)
//        SwitchingPos=9;   
//   }
//
//  if (phi==0)
//    {
//    if (Tor==0)
//        SwitchingPos=10;
//    if (Tor==1)
//        SwitchingPos=3;   
//    if (Tor==-1)
//        SwitchingPos=6;
//    }   
//}
//  
// if(BemfLevel==-1) 
//  { 
//  if (phi==1)
//   {
//    if (Tor==0)
//        SwitchingPos=10; 
//    if (Tor==1)
//        SwitchingPos=1;  
//    if (Tor==-1)
//        SwitchingPos=8; 
//   }
//
//  if (phi==0)
//   {
//    if (Tor==0)
//        SwitchingPos=10;
//    if (Tor==1)
//        SwitchingPos=4;   
//    if (Tor==-1)
//        SwitchingPos=7;  
//   }
// }
//
// SwitchingPos=SwitchingPos+(SectorNum_F-1);
// SwitchingPos=SwitchingPos%10;
    
//%----------------------------Using 72 degree vectors-----------------------

    
//   if (phi==1)
//    {
//     if (Tor==1)
//         SwitchingPos=2; 
//     if (Tor==-1)
//         SwitchingPos=8; 
//   	 }
//   if (phi==0)
//    {
//     if (Tor==1)
//         SwitchingPos=3; 
//     if (Tor==-1)
//         SwitchingPos=7;
//    }    
//  
//     SwitchingPos=SwitchingPos+(SectorNum_F-1);
//     SwitchingPos=SwitchingPos%10;
//
//
//--------------------------------------------------------------------------
  
  if (Tor==0)
  {    
     Vd1ss=0; 
     Vq1ss=0; 
     Vd3ss=0;
     Vq3ss=0;
	 SwitchStateA=1;
     SwitchStateB=1;
     SwitchStateC=1;
     SwitchStateD=1;
     SwitchStateE=1;

  }
  else
  {
  if (SwitchingPos==0)
    {
      //if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==9||SectorNum_A==10)
	  if(StatorFluxAng_A>4.712238898||StatorFluxAng_A<1.570796327)
	      {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=2;
		  }
      else
          {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));
		   
		   SwitchStateA=2;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
	  	  }
    }
      
  else if (SwitchingPos==1)
    {
     // if (SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6)
	   if(StatorFluxAng_A>=0.314159265&&StatorFluxAng_A<=3.455751919)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
      else
	     {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=1;
           SwitchStateD=0;
           SwitchStateE=1;
	  	 }
    }
 else if (SwitchingPos==2)
    {
     // if (SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9)
	   if(StatorFluxAng_A>=2.199114858&&StatorFluxAng_A<=5.340707511)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
      else
	     {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=2;
           SwitchStateC=1;
           SwitchStateD=0;
           SwitchStateE=0;
        }
   }
 else if (SwitchingPos==3)
   {
     // if (SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1||SectorNum_A==2)
	   if(StatorFluxAng_A>=4.08407045||StatorFluxAng_A<=0.942477796)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
      else
	      {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=1;
           SwitchStateE=0;
	  	  }
     }
  else if (SwitchingPos==4)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5)
	   if(StatorFluxAng_A>=5.969026042 || StatorFluxAng_A<=2.827433388)
	      {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=0;
		  }
      else
	      {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=1;
           SwitchStateC=2;
           SwitchStateD=1;
           SwitchStateE=0;
          }
    }
   else if (SwitchingPos==5)
      {
     // if (SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8)
	     
	   if (StatorFluxAng_A>=1.570796327&&StatorFluxAng_A<=4.71238898)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=0;
	     }
      else
	    {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=1;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=1;
	    }
   }
   else if (SwitchingPos==6)
      {
      //if (SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1)
	    if(StatorFluxAng_A>=3.455751919||StatorFluxAng_A<=0.314159265)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=2;
		}
      else
	     {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=2;
           SwitchStateE=1;
	  	 }
   }
   else if (SwitchingPos==7)
    {
     // if (SectorNum_A==10||SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4)
	   if(StatorFluxAng_A>=5.340707511 || StatorFluxAng_A<=2.199114858)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=2;
           SwitchStateE=2;
		  }
      else
	     {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=2;
           SwitchStateE=2;
	   }
   }
   else if (SwitchingPos==8)

    {
      //if (SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7)
	   if(StatorFluxAng_A>=0.942477796&&StatorFluxAng_A<=4.08407045) 
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=2;
           SwitchStateE=2;
		  }
      else
	      {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=1;
           SwitchStateE=2;
		  }
     }
  else if (SwitchingPos==9)
    {
      //if (SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10)
	    if (StatorFluxAng_A>=2.827433388 && StatorFluxAng_A<=5.969026042)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=2;
		  }
      else
	     {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=1;
           SwitchStateE=2;
		  }
	 }
     
  else
         {
          Vd1ss=0; 
          Vq1ss=0;
          Vd3ss=0;
          Vq3ss=0;
		  SwitchStateA=1;
          SwitchStateB=1;
          SwitchStateC=1;
          SwitchStateD=1;
          SwitchStateE=1;

		  }
 }
	 
         Vdq[0]=Vd1ss;
 		 Vdq[1]=Vq1ss;
		 Vdq[2]=Vd3ss;
		 Vdq[3]=Vq3ss;
		 IGBTState[0]=SwitchStateA;
		 IGBTState[1]=SwitchStateB;
		 IGBTState[2]=SwitchStateC;
		 IGBTState[3]=SwitchStateD;
		 IGBTState[4]=SwitchStateE;

}

//--------------------------------d1-q1 SM  parameter initialization----------
void SMOParameterIni_F(void)
{
        float ar11, ar12;
        float ar21, ar22;
        float b1;
		unsigned int m, n;

        //Parameters initialization
        //****************************************************************************
           ar11=-(Rs1/(Q1*Ls1)+Rr1*Lm1*Lm1/(Lr1*Lr1*Q1*Ls1));
           ar12=Lm1*Rr1/(Q1*Ls1*Lr1*Lr1);
           ar21=Rr1*Lm1/Lr1; 
           ar22=-Rr1/Lr1; 
           b1=1/(Q1*Ls1);

          
            // ar11=-148.35;  ar12=436.40;
	        // ar21=0.486542;  ar22=-3.45;
	        // b1=129.968;

//----------------------------------------------------------------------------
             A[0][0]=ar11; A[0][2]=ar12;
             A[1][1]=ar11; A[1][3]=ar12;
             A[2][0]=ar21; A[2][2]=ar22;
             A[3][1]=ar21; A[3][3]=ar22;

             B[0][0]=b1; B[1][1]=b1;
//----------------------------------------------------------------------------
             for (m=0;m<=3;m++)                   //Bdk=Ts*B
            {
                for (n=0;n<=1;n++)
                {
                  Bdk[m][n]=B[m][n]*Ts;
                }
            }
    
}

//---------------------d3-q3 SM parameter initialzation------------------------

void SMOParameterIni_A(void)
{
        float ar11, ar12;
        float ar21, ar22;
        float b1;
		unsigned int m, n;

        //Parameters initialization
        //****************************************************************************
       ar11=-(Rs1/(Q3*Ls3)+Rr3*Lm3*Lm3/(Lr3*Lr3*Q3*Ls3));
       ar12=Lm3*Rr3/(Q3*Ls3*Lr3*Lr3);
       ar21=Rr3*Lm3/Lr3; 
       ar22=-Rr3/Lr3; 
       b1=1/(Q3*Ls3);

//        ar11=-212.2962;  ar12=5123.88;
//	  	ar21=0.27968;  ar22=-25.197;
//	  	b1=232.6666;
//----------------------------------------------------------------------------
        A_A[0][0]=ar11; A_A[0][2]=ar12;
        A_A[1][1]=ar11; A_A[1][3]=ar12;
        A_A[2][0]=ar21; A_A[2][2]=ar22;
        A_A[3][1]=ar21; A_A[3][3]=ar22;

        B_A[0][0]=b1; B_A[1][1]=b1;
//----------------------------------------------------------------------------
        for (m=0;m<=3;m++)                   //Bdk=Ts*B
          {
             for (n=0;n<=1;n++)
              {
               Bdk_A[m][n]=B_A[m][n]*Ts;
              }
          }
    
}


//---------------------------d3  q3  SMO---------------------------------------


void SlidingModeFluxObserver_A(float RotorSpeed,float Id3ss, float Iq3ss, float Vd3ss, float Vq3ss, float CurrentAndFlux3[4])

{
   //----------------------------------------------------------------------------
   float k3[1][2];  
   float k4[1][2];
   float L[2][2];
     
   float Vk[2][1];
   float Xk[4][1];
   float Xk1[4][1];


   int Sign_s1, Sign_s2;
   
   float s1, s2;
//----------------------------------------------------------------------------     					
   
   float tempf3;
   float tempf1;
   float tempf2;

   unsigned int m, n, i;
   float ai12, ai22;

  tempf3=Rr3*Rr3+3*RotorSpeed*Lr3*3*RotorSpeed*Lr3;	 
  tempf1=-Q3*Ls3*Lr3/Lm3*(1+(-15)*Rr3*Lr3/tempf3);
  tempf2= Q3*Ls3*Lr3/Lm3*(-15)*3*RotorSpeed*Lr3*Lr3/tempf3;

  L[0][0]= tempf1; L[0][1]=tempf2;
  L[1][0]=-tempf2; L[1][1]=tempf1;

  k3[0][0]=k1*L[0][0]; k3[0][1]=k2*L[0][1];
  k4[0][0]=k1*L[1][0]; k4[0][1]=k2*L[1][1];

//----------------------------------------------------------------------------
  ai12=-Lm3/(Q3*Ls3*Lr3)*3*RotorSpeed;	 //Discrete model update
  ai22=3*RotorSpeed;	       
  A_A[0][3]=-ai12; A_A[1][2]=ai12;    	    
  A_A[2][3]=-ai22; A_A[3][2]=ai22; 

//----------------------------------------------------------------------------
  for (m=0;m<=3;m++)                   //Adk=I4+A*Ts
  { 						           //Bdk=Ts*B
     for (n=0;n<=3;n++)
     {
        Adk_A[m][n]=I4[m][n]+A_A[m][n]*Ts;
     }
  }	
//----------------------------------------------------------------------------
  Xk[0][0]=Id3sso; Xk[2][0]=Lamda_d3rso;
  Xk[1][0]=Iq3sso; Xk[3][0]=Lamda_q3rso;
  Vk[0][0]=Vd3ss;  Vk[1][0]=Vq3ss;

//----------------------------------------------------------------------------  
  for (m=0;m<=3;m++)		           //Xk+1=Adk*Xk+Bdk*Vk
  {
  Xk1[m][0]=0;

  for (i=0;i<=3;i++)
  Xk1[m][0]=Xk1[m][0]+Adk_A[m][i]*Xk[i][0];

  for (i=0;i<=1;i++)
  Xk1[m][0]=Xk1[m][0]+Bdk_A[m][i]*Vk[i][0];
  }
//----------------------------------------------------------------------------
  Id3sso=Xk1[0][0]; Lamda_d3rso=Xk1[2][0];
  Iq3sso=Xk1[1][0]; Lamda_q3rso=Xk1[3][0];

//----------------------------------------------------------------------------
  s1=Id3ss-Id3sso; s2=Iq3ss-Iq3sso;        //Model compensation 
  
  if      (s1>0)  Sign_s1=1;
  else if (s1<0)  Sign_s1=-1;
  else            Sign_s1=0;

  if      (s2>0)  Sign_s2=1;
  else if (s2<0)  Sign_s2=-1;
  else            Sign_s2=0;
    
  Id3sso=Id3sso+Ts*k1*Sign_s1;
  Iq3sso=Iq3sso+Ts*k2*Sign_s2;

  Lamda_d3rso=Lamda_d3rso+Ts*(k3[0][0]*Sign_s1+k3[0][1]*Sign_s2);
  Lamda_q3rso=Lamda_q3rso+Ts*(k4[0][0]*Sign_s1+k4[0][1]*Sign_s2);
  CurrentAndFlux3[0]=Id3sso;
  CurrentAndFlux3[1]=Iq3sso;
  CurrentAndFlux3[2]=Lamda_d3rso;
  CurrentAndFlux3[3]=Lamda_q3rso;
    
}

void DTCLookUpTableWithNPCompensation (float Ia,float Ib, float Ic, float Id, float Ie, unsigned int HysteresisStatus, float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5])
{
  // float tempf;
	  
  //------------ in this function, the largest, second largest vectors and the midium redundant vectors 
  //------------are used to produce sinusoidals, there is NP control by using Hysteresis method-------------- 

    SectorNum_F=1;
    if (StatorFluxAng_F>(5.969026042))	 //19*pi/10
        SectorNum_F=1;    
    else if (StatorFluxAng_F>(5.340707511)) //17*pi/10
       SectorNum_F=10;
    else if (StatorFluxAng_F>(4.71238898))  //15*pi/10
       SectorNum_F=9 ; 
    else if (StatorFluxAng_F>(4.08407045))	//13*pi/10
       SectorNum_F=8;
    else if (StatorFluxAng_F>(3.455751919))	// 11*pi/10
       SectorNum_F=7;
    else if (StatorFluxAng_F>(2.827433388))	//9*pi/10
       SectorNum_F=6;
    else if (StatorFluxAng_F>(2.199114858))	// 7*pi/10
       SectorNum_F=5;
    else if (StatorFluxAng_F>(1.570796327))	//5*pi/10
       SectorNum_F=4;
    else if (StatorFluxAng_F>(0.942477796))		//3*pi/10
           SectorNum_F=3;
    else if (StatorFluxAng_F>(0.314159265))	   //pi/10
       SectorNum_F=2; 
    else
       SectorNum_F=1;
   
  //--------------------------Hysteresis band----------------------------------------
         phi=0;
      if (FlxErr+FluxBand<0)  
         phi=0;
  
      if (FlxErr-FluxBand>0)  
         phi=1;
  
        Tor=0;
      if (TorErr+TorqueBand<0)  
        Tor=-1;
  
      if (TorErr-TorqueBand>0) 
         Tor=1;
  
  //-----------------------------Back_Emf Calculation-----------------------
      BemfLevel=0;
      if (RotorSpeed>314/10) BemfLevel=1;
      if (RotorSpeed<-314/10) BemfLevel=-1;

    //   BemfLevel=0;

                 
 // %------------------------------Space Vector Selection based on Bemf info----  
 if(BemfLevel==0) 
 {    
  if (phi==1)
    {
    if (Tor==1)
        SwitchingPos=1;  
    if (Tor==-1)
        SwitchingPos=9; 
    }

  if (phi==0)
    {
    if (Tor==1)
        SwitchingPos=4; 
    if (Tor==-1)
        SwitchingPos=6; 
    }   
 } 


if(BemfLevel==1)
{  
  if (phi==1)
   {
    if (Tor==1)
        SwitchingPos=2; 
    if (Tor==-1)
        SwitchingPos=9;   
   }

  if (phi==0)
    {
    if (Tor==1)
        SwitchingPos=3;   
    if (Tor==-1)
        SwitchingPos=6;
    }   
}
  
 if(BemfLevel==-1) 
  { 
  if (phi==1)
   {
   if (Tor==1)
        SwitchingPos=1;  
    if (Tor==-1)
        SwitchingPos=8; 
   }

  if (phi==0)
   {
    if (Tor==1)
        SwitchingPos=4;   
    if (Tor==-1)
        SwitchingPos=7;  
   }
 }

 SwitchingPos=SwitchingPos+(SectorNum_F-1);
 SwitchingPos=SwitchingPos%10;
//    
//%----------------------------Using 36 degree vectors-----------------------

    
//   if (phi==1)
//    {
//     if (Tor==1)
//         SwitchingPos=2; 
//     if (Tor==-1)
//         SwitchingPos=8; 
//   	 }
//   if (phi==0)
//    {
//     if (Tor==1)
//         SwitchingPos=3; 
//     if (Tor==-1)
//         SwitchingPos=7;
//    }    
//  
//     SwitchingPos=SwitchingPos+(SectorNum_F-1);
//     SwitchingPos=SwitchingPos%10;
//

//--------------------------------------------------------------------------
  
  if (Tor==0)
  {    
     Vd1ss=0; 
     Vq1ss=0; 
     Vd3ss=0;
     Vq3ss=0;
	 SwitchStateA=1;
     SwitchStateB=1;
     SwitchStateC=1;
     SwitchStateD=1;
     SwitchStateE=1;

  }
  else
  {
  if (SwitchingPos==0)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==9||SectorNum_A==10)
	  if(StatorFluxAng_A>4.712238898||StatorFluxAng_A<1.570796327)
	      {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=2;
		  }
      else
          {
		  if(HysteresisStatus==0)
		  {
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));
		   
		   SwitchStateA=2;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
		  }
         
		  else if ((Ia>=0&&HysteresisStatus==1)||(Ia<0&&HysteresisStatus==1))
		  {
		    Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		    SwitchStateA=1;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=0;
            SwitchStateE=0;
		  }
		   else //if ((Ia>=0&&HysteresisStatus==2)||(Ia<0&&HysteresisStatus==2))
		  {
		    Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		    SwitchStateA=2;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=1;
            SwitchStateE=1;
		  }

	  	  }
    }
      
  else if (SwitchingPos==1)
    {
     // if (SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6)
	   if(StatorFluxAng_A>=0.314159265&&StatorFluxAng_A<=3.455751919)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
      else
	     {

         if(HysteresisStatus==0)
         {
            Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=2;
            SwitchStateB=2;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=1;
		  }
		    
           else if ((-Id>=0&&HysteresisStatus==1)||(-Id<0&&HysteresisStatus==1))
		   {
			Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=1;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=1;
		   }

           else //if ((-Id>=0&&HysteresisStatus==2)||(-Id<0&&HysteresisStatus==2))
		   {
			Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=2;
            SwitchStateB=2;
            SwitchStateC=2;
            SwitchStateD=1;
            SwitchStateE=2;
		   }
	  	 }
    }
 else if (SwitchingPos==2)
    {
          // if (SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9)
	   if(StatorFluxAng_A>=2.199114858&&StatorFluxAng_A<=5.340707511)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
      else
	     {
		  if(HysteresisStatus==0)
		  {
            Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=2;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=0;
		  }
		    
       	 else if ((Ib>=0&&HysteresisStatus==1)||(Ib<0&&HysteresisStatus==1))
		 {
		 	 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		 	 SwitchStateA=0;
             SwitchStateB=1;
             SwitchStateC=0;
             SwitchStateD=0;
             SwitchStateE=0;
		 }
		// else
       else// if ((Ib>=0&&HysteresisStatus==2)||(Ib<0&&HysteresisStatus==2))
		 {
		 	 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		 	 SwitchStateA=1;
             SwitchStateB=2;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;
		 }

       }
   }
 else if (SwitchingPos==3)
   {
          //if (SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1||SectorNum_A==2)
	   if(StatorFluxAng_A>=4.08407045||StatorFluxAng_A<=0.942477796)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
      else
	      {
             if(HysteresisStatus==0)
            {
             Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=2;
             SwitchStateC=2;
             SwitchStateD=1;
             SwitchStateE=0;
		    }
			 			
			 else if ((-Ie>=0&&HysteresisStatus==1)||(-Ie<0&&HysteresisStatus==1))

			  {
		 	     Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			  	 SwitchStateA=1;
                 SwitchStateB=1;
                 SwitchStateC=1;
                 SwitchStateD=1;
                 SwitchStateE=0;
			  }
			 // else
			else //if ((-Ie>=0&&HysteresisStatus==2)||(-Ie<0&&HysteresisStatus==2))
			 {
			  	 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			  	 
			  	 SwitchStateA=2;
                 SwitchStateB=2;
                 SwitchStateC=2;
                 SwitchStateD=2;
                 SwitchStateE=1;
			  }

	  	  }
     }
  else if (SwitchingPos==4)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5)
	   if(StatorFluxAng_A>=5.969026042 || StatorFluxAng_A<=2.827433388)
	      {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=2;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=0;
		  }
      else
	      {

            if(HysteresisStatus==0)
            {
              Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=2;
              SwitchStateD=1;
              SwitchStateE=0;
			  }
			
		   else	if ((Ic>=0&&HysteresisStatus==1)||(Ic<0&&HysteresisStatus==1))

			{
			  Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			  
			  SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=0;
              SwitchStateE=0;
		    }
          // else
		   else //if ((Ic>=0&&HysteresisStatus==2)||(Ic<0&&HysteresisStatus==2))
			{
			  Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			  
			  SwitchStateA=1;
              SwitchStateB=1;
              SwitchStateC=2;
              SwitchStateD=1;
              SwitchStateE=1;
		    }
          }
    }
   else if (SwitchingPos==5)
      {
     // if (SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8)
	     
	   if (StatorFluxAng_A>=1.570796327&&StatorFluxAng_A<=4.71238898)
	     {
           Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=0;
	     }
      else
	    {
		    if(HysteresisStatus==0)
            {
            Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=0;
            SwitchStateB=1;
            SwitchStateC=2;
            SwitchStateD=2;
            SwitchStateE=1;
			}
						
		  else if ((-Ia>=0&&HysteresisStatus==1)||(-Ia<0&&HysteresisStatus==1))
			{
			
			Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=0;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=1;
            SwitchStateE=1;

			}
		  else// if ((-Ia>=0&&HysteresisStatus==2)||(-Ia<0&&HysteresisStatus==2))
		   //	else
			{
			Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=1;
            SwitchStateB=2;
            SwitchStateC=2;
            SwitchStateD=2;
            SwitchStateE=2;
			}


	    }
   }
   else if (SwitchingPos==6)
      {
      //if (SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1)
	    if(StatorFluxAng_A>=3.455751919||StatorFluxAng_A<=0.314159265)
	     {
          Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=2;
           SwitchStateD=2;
           SwitchStateE=2;
		}
      else
	     {

           if(HysteresisStatus==0)
			{
             Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=2;
             SwitchStateE=1;
            }
		 else if ((Id>=0&&HysteresisStatus==1)||(Id<0&&HysteresisStatus==1))
		  {
		  	 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		  	 
		  	 SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=0;
 		  }
		 // else
		 else// if ((Id>=0&&HysteresisStatus==2)||(Id<0&&HysteresisStatus==2))
		   {
		  	 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));
 
		  	 SwitchStateA=1;
             SwitchStateB=1;
             SwitchStateC=1;
             SwitchStateD=2;
             SwitchStateE=1;
   		  }

	  }
   }
   else if (SwitchingPos==7)
    {
     // if (SectorNum_A==10||SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4)
	   if(StatorFluxAng_A>=5.340707511 || StatorFluxAng_A<=2.199114858)
	     {
           Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=2;
           SwitchStateE=2;
		  }
      else
	     {
           
            if(HysteresisStatus==0)
          {
           Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=2;
           SwitchStateE=2;
		  }
		   
		   else if ((-Ib>=0&&HysteresisStatus==1)||(-Ib<0&&HysteresisStatus==1))
		  {
		  	 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		  	 SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;

		  }
		  //else
		  else //if ((-Ib>=0&&HysteresisStatus==2)||(-Ib<0&&HysteresisStatus==2))

		  {
		     Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		  	 SwitchStateA=2;
             SwitchStateB=1;
             SwitchStateC=2;
             SwitchStateD=2;
             SwitchStateE=2;
		  }
	   }
   }
   else if (SwitchingPos==8)

    {
      //if (SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7)
	   if(StatorFluxAng_A>=0.942477796&&StatorFluxAng_A<=4.08407045) 
	     {
           Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=2;
           SwitchStateE=2;
		  }
      else
	      {
		   if(HysteresisStatus==0)
		   {
            Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=1;
            SwitchStateE=2;
			}
		   
		  else if ((Ie>=0&&HysteresisStatus==1)||(Ie<0&&HysteresisStatus==1))

            {
			 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=0;
             SwitchStateE=1;
            }
		  //else
		 else // if ((Ie>=0&&HysteresisStatus==2)||(Ie<0&&HysteresisStatus==2)) 
			 {

             Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=1;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=2;
            }

		  }
     }
  else if (SwitchingPos==9)
    {
      //if (SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10)
	    if (StatorFluxAng_A>=2.827433388 && StatorFluxAng_A<=5.969026042)
	     {
           Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=2;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=2;
		  }
      else
	     {	  
	        if(HysteresisStatus==0)
			 {
             Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=2;
             SwitchStateB=1;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=2;
			 }
			 			 
		    else if ((-Ic>=0&&HysteresisStatus==1)||(-Ic<0&&HysteresisStatus==1))
			 {
			 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			 SwitchStateA=1;
             SwitchStateB=1;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=1; 
			 }
			// else
		    else //if ((-Ic>=0&&HysteresisStatus==2)||(-Ic<0&&HysteresisStatus==2))
			 {
			 Vd1ss=0.2*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			 SwitchStateA=2;
             SwitchStateB=2;
             SwitchStateC=1;
             SwitchStateD=2;
             SwitchStateE=2; 
			 }
  
		  }
	 }
     
     else
         {
          Vd1ss=0; 
          Vq1ss=0;
          Vd3ss=0;
          Vq3ss=0;
		  SwitchStateA=1;
          SwitchStateB=1;
          SwitchStateC=1;
          SwitchStateD=1;
          SwitchStateE=1;

		  }
    }
	 
         Vdq[0]=Vd1ss;
 		 Vdq[1]=Vq1ss;
		 Vdq[2]=Vd3ss;
		 Vdq[3]=Vq3ss;
		 IGBTState[0]=SwitchStateA;
		 IGBTState[1]=SwitchStateB;
		 IGBTState[2]=SwitchStateC;
		 IGBTState[3]=SwitchStateD;
		 IGBTState[4]=SwitchStateE;

}



//------------------Look up table three: Neutral point compensation----------------------
//---------------------------------------------------------------------------------------

int DTCLookUpTable3WithNPBalance (float Ia,float Ib, float Ic, float Id, float Ie,unsigned int HysteresisStatus,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5], unsigned int NPImbalance)

 {
  // float tempf;
	  
  //------------ in this function second largest vectors and the largest redundant vectors 
  //------------are used to produce sinusoidals, there is NP control by using Hysteresis method-------------- 

    SectorNum_F=1;
    if (StatorFluxAng_F>(5.969026042))	 //19*pi/10
        SectorNum_F=1;    
    else if (StatorFluxAng_F>(5.340707511)) //17*pi/10
       SectorNum_F=10;
    else if (StatorFluxAng_F>(4.71238898))  //15*pi/10
       SectorNum_F=9 ; 
    else if (StatorFluxAng_F>(4.08407045))	//13*pi/10
       SectorNum_F=8;
    else if (StatorFluxAng_F>(3.455751919))	// 11*pi/10
       SectorNum_F=7;
    else if (StatorFluxAng_F>(2.827433388))	//9*pi/10
       SectorNum_F=6;
    else if (StatorFluxAng_F>(2.199114858))	// 7*pi/10
       SectorNum_F=5;
    else if (StatorFluxAng_F>(1.570796327))	//5*pi/10
       SectorNum_F=4;
    else if (StatorFluxAng_F>(0.942477796))		//3*pi/10
           SectorNum_F=3;
    else if (StatorFluxAng_F>(0.314159265))	   //pi/10
       SectorNum_F=2; 
    else
       SectorNum_F=1;
   
  //--------------------------Hysteresis band----------------------------------------
         phi=0;
      if (FlxErr+FluxBand<0)  
         phi=0;
  
      if (FlxErr-FluxBand>0)  
         phi=1;
  
        Tor=0;
      if (TorErr+TorqueBand<0)  
        Tor=-1;
  
      if (TorErr-TorqueBand>0) 
         Tor=1;
  
  //-----------------------------Back_Emf Calculation-----------------------
      BemfLevel=0;
      if (RotorSpeed>314/10) BemfLevel=1;
      if (RotorSpeed<-314/10) BemfLevel=-1;

    //   BemfLevel=0;
                
 // %------------------------------Space Vector Selection based on Bemf info----  
 if(BemfLevel==0) 
 {    
  if (phi==1)
    {
    if (Tor==1)
        SwitchingPos=1;  
    if (Tor==-1)
        SwitchingPos=9; 
    }

  if (phi==0)
    {
    if (Tor==1)
        SwitchingPos=4; 
    if (Tor==-1)
        SwitchingPos=6; 
    }   
 } 


if(BemfLevel==1)
{  
  if (phi==1)
   {
    if (Tor==1)
        SwitchingPos=2; 
    if (Tor==-1)
        SwitchingPos=9;   
   }

  if (phi==0)
    {
    if (Tor==1)
        SwitchingPos=3;   
    if (Tor==-1)
        SwitchingPos=6;
    }   
}
  
 if(BemfLevel==-1) 
  { 
  if (phi==1)
   {
   if (Tor==1)
        SwitchingPos=1;  
    if (Tor==-1)
        SwitchingPos=8; 
   }

  if (phi==0)
   {
    if (Tor==1)
        SwitchingPos=4;   
    if (Tor==-1)
        SwitchingPos=7;  
   }
 }

 SwitchingPos=SwitchingPos+(SectorNum_F-1);
 SwitchingPos=SwitchingPos%10;
    
//%----------------------------Using 36 degree vectors-----------------------

    
//   if (phi==1)
//    {
//     if (Tor==1)
//         SwitchingPos=1; 
//     if (Tor==-1)
//         SwitchingPos=9; 
//   	 }
//   if (phi==0)
//    {
//     if (Tor==1)
//         SwitchingPos=4; 
//     if (Tor==-1)
//         SwitchingPos=6;
//    }    
//  
//     SwitchingPos=SwitchingPos+(SectorNum_F-1);
//     SwitchingPos=SwitchingPos%10;
//

//--------------------------------------------------------------------------
  
  if (Tor==0)
  {    
     Vd1ss=0; 
     Vq1ss=0; 
     Vd3ss=0;
     Vq3ss=0;
	 SwitchStateA=1;
     SwitchStateB=1;
     SwitchStateC=1;
     SwitchStateD=1;
     SwitchStateE=1;

  }
  else
  {
  if (SwitchingPos==0)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==9||SectorNum_A==10)
	  if(StatorFluxAng_A>4.712238898||StatorFluxAng_A<1.570796327)
	      {
          
           if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=2;
              SwitchStateB=2;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=2;
			  }
             
            else 
             {
               if (((Ia+Ib+Ie)>=0&&HysteresisStatus==1)||((Ia+Ib+Ie)<0&&HysteresisStatus==1))
		         {
		         Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		         SwitchStateA=1;
                 SwitchStateB=1;
                 SwitchStateC=0;
                 SwitchStateD=0;
                 SwitchStateE=1;
		        }
		       else //if ((Ia>=0&&HysteresisStatus==2)||(Ia<0&&HysteresisStatus==2))
		        {
		         Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		         SwitchStateA=2;
                 SwitchStateB=2;
                 SwitchStateC=1;
                 SwitchStateD=1;
                 SwitchStateE=2;
		       }
			 }
		    }
      else
          {
		  Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));
		   
		   SwitchStateA=2;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
		  }
         
   }
      
  else if (SwitchingPos==1)
    {
     // if (SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6)
	   if(StatorFluxAng_A>=0.314159265&&StatorFluxAng_A<=3.455751919)
	     {
             if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=2;
              SwitchStateB=2;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=0;
			  }
             
            else 
             { 
            
               if (((Ia+Ib)>=0&&HysteresisStatus==1)||((Ia+Ib)<0&&HysteresisStatus==1))
		        {
			      Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                  Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                  Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                  Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			      SwitchStateA=1;
                  SwitchStateB=1;
                  SwitchStateC=0;
                  SwitchStateD=0;
                  SwitchStateE=0;
		        }

              else //if ((-Id>=0&&HysteresisStatus==2)||(-Id<0&&HysteresisStatus==2))
		        {
			      Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                  Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                  Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                  Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			      SwitchStateA=2;
                  SwitchStateB=2;
                  SwitchStateC=1;
                  SwitchStateD=1;
                  SwitchStateE=1;
		        }
			}
		 }
      else
	     {

            Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=2;
            SwitchStateB=2;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=1;		    
        }
    }
 else if (SwitchingPos==2)
    {
          // if (SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9)
	   if(StatorFluxAng_A>=2.199114858&&StatorFluxAng_A<=5.340707511)
	     {
            if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=2;
              SwitchStateB=2;
              SwitchStateC=2;
              SwitchStateD=0;
              SwitchStateE=0;
			  }
            else
             { 
               if (((Ia+Ib+Ic)>=0&&HysteresisStatus==1)||((Ia+Ib+Ic)<0&&HysteresisStatus==1))
		       {
		 	     Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		 	     SwitchStateA=1;
                 SwitchStateB=1;
                 SwitchStateC=1;
                 SwitchStateD=0;
                 SwitchStateE=0;
		       }
		// else
            else// if ((Ib>=0&&HysteresisStatus==2)||(Ib<0&&HysteresisStatus==2))
		       {
		 	   Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
               Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
               Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
               Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		 	   SwitchStateA=2;
               SwitchStateB=2;
               SwitchStateC=2;
               SwitchStateD=1;
               SwitchStateE=1;
		       }
	  	   }
	  }	   
      else
	     {
		    Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=2;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=0;       	
       }
   }
 else if (SwitchingPos==3)
   {
          //if (SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1||SectorNum_A==2)
	   if(StatorFluxAng_A>=4.08407045||StatorFluxAng_A<=0.942477796)
	     {
         
          if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=2;
              SwitchStateC=2;
              SwitchStateD=0;
              SwitchStateE=0;
			  }
            else
             { 

             if (((Ib+Ic)>=0&&HysteresisStatus==1)||((Ib+Ic)<0&&HysteresisStatus==1))

			  {
		 	    Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  	 SwitchStateA=0;
                 SwitchStateB=1;
                 SwitchStateC=1;
                 SwitchStateD=0;
                 SwitchStateE=0;
			  }
			 
			else //if ((-Ie>=0&&HysteresisStatus==2)||(-Ie<0&&HysteresisStatus==2))
			 {
			  	Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
                Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
                Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
                Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  	 
			  	 SwitchStateA=1;
                 SwitchStateB=2;
                 SwitchStateC=2;
                 SwitchStateD=1;
                 SwitchStateE=1;
			  }
			}
		  }
      else
	      {
             Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=2;
             SwitchStateC=2;
             SwitchStateD=1;
             SwitchStateE=0;
		   		
		  }
     }
  else if (SwitchingPos==4)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5)
	   if(StatorFluxAng_A>=5.969026042 || StatorFluxAng_A<=2.827433388)
	      {
            if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=2;
              SwitchStateC=2;
              SwitchStateD=2;
              SwitchStateE=0;
			  }
            else
             { 
              if (((Ib+Ic+Id)>=0&&HysteresisStatus==1)||((Ib+Ic+Id)<0&&HysteresisStatus==1))

		     {
			  Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  
			  SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;
		    }
          // else
		   else //if ((Ic>=0&&HysteresisStatus==2)||(Ic<0&&HysteresisStatus==2))
			{
			 Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  
			  SwitchStateA=1;
              SwitchStateB=2;
              SwitchStateC=2;
              SwitchStateD=2;
              SwitchStateE=1;
		    }
		   }
		  }
      else
	      {

              Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=2;
              SwitchStateD=1;
              SwitchStateE=0;
		 }
    }
   else if (SwitchingPos==5)
      {
     // if (SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8)
	     
	   if (StatorFluxAng_A>=1.570796327&&StatorFluxAng_A<=4.71238898)
	     {
             if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=2;
              SwitchStateD=2;
              SwitchStateE=0;
			  }
            else
             { 
            
            if (((Ic+Id)>=0&&HysteresisStatus==1)||((Ic+Id)<0&&HysteresisStatus==1))
			{
			  Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;

			}
		  else// if ((-Ia>=0&&HysteresisStatus==2)||(-Ia<0&&HysteresisStatus==2))
		   //	else
			{
			  Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  SwitchStateA=1;
              SwitchStateB=1;
              SwitchStateC=2;
              SwitchStateD=2;
              SwitchStateE=1;
			}
  	       }
  	     }
      else
	    {
		    Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=0;
            SwitchStateB=1;
            SwitchStateC=2;
            SwitchStateD=2;
            SwitchStateE=1;
		  		
		}
   }
   else if (SwitchingPos==6)
      {
      //if (SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1)
	    if(StatorFluxAng_A>=3.455751919||StatorFluxAng_A<=0.314159265)
	     {
            if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=2;
              SwitchStateD=2;
              SwitchStateE=2;
			  }
            else
             { 

           
           if (((Ic+Id+Ie)>=0&&HysteresisStatus==1)||((Ic+Id+Ie)<0&&HysteresisStatus==1))
		    {
		  	 Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		  	 
		  	 SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;
 		    }
		 // else
		 else// if ((Id>=0&&HysteresisStatus==2)||(Id<0&&HysteresisStatus==2))
		    {
		  	 Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));
 
		  	 SwitchStateA=1;
             SwitchStateB=1;
             SwitchStateC=2;
             SwitchStateD=2;
             SwitchStateE=2;
   		    }
		  }
		}
      else
	     {
           Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=2;
           SwitchStateE=1;
		  }
   }
   else if (SwitchingPos==7)
    {
     // if (SectorNum_A==10||SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4)
	   if(StatorFluxAng_A>=5.340707511 || StatorFluxAng_A<=2.199114858)
	     {

            if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=2;
              SwitchStateE=2;
			  }
            else
             { 

           if (((Id+Ie)>=0&&HysteresisStatus==1)||((Id+Ie)<0&&HysteresisStatus==1))
		     {
		  	   Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
               Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
               Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
               Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		  	   SwitchStateA=0;
               SwitchStateB=0;
               SwitchStateC=0;
               SwitchStateD=1;
               SwitchStateE=1;

		      }
		  //else
		  else //if ((-Ib>=0&&HysteresisStatus==2)||(-Ib<0&&HysteresisStatus==2))

		     {
		      Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

		  	  SwitchStateA=1;
              SwitchStateB=1;
              SwitchStateC=1;
              SwitchStateD=2;
              SwitchStateE=2;
		    }
		   }
		  }
      else
	     {
           
           Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=2;
           SwitchStateE=2;
	     }
   }
   else if (SwitchingPos==8)

    {
      //if (SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7)
	   if(StatorFluxAng_A>=0.942477796&&StatorFluxAng_A<=4.08407045) 
	     {
            if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=2;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=2;
              SwitchStateE=2;
			  }
            else
             { 

           if (((Ia+Id+Ie)>=0&&HysteresisStatus==1)||((Ia+Id+Ie)<0&&HysteresisStatus==1))

            {
			  Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=1;
            }
		  //else
		 else // if ((Ie>=0&&HysteresisStatus==2)||(Ie<0&&HysteresisStatus==2)) 
			 {

              Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=2;
              SwitchStateB=1;
              SwitchStateC=1;
              SwitchStateD=2;
              SwitchStateE=2;
            }
		   }
		  }
      else
	      {
		    Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=1;
            SwitchStateE=2;
   		  }
     }
  else if (SwitchingPos==9)
    {
      //if (SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10)
	    if (StatorFluxAng_A>=2.827433388 && StatorFluxAng_A<=5.969026042)
	     {
             if(NPImbalance==0)
		     {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=2;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=2;
			  }
            else
             { 

            
            if (((Ia+Ie)>=0&&HysteresisStatus==1)||((Ia+Ie)<0&&HysteresisStatus==1))
			 {
			  Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			  SwitchStateA=1;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=1; 
			 }
			// else
		    else //if ((-Ic>=0&&HysteresisStatus==2)||(-Ic<0&&HysteresisStatus==2))
			 {
			  Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.1236*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.1236*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

			 SwitchStateA=2;
             SwitchStateB=1;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=2; 
			 }
  			}
		  }
      else
	     {	  
	         Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.0764*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.0764*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=2;
             SwitchStateB=1;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=2;
		  
		  }
	 }
     
     else
         {
          Vd1ss=0; 
          Vq1ss=0;
          Vd3ss=0;
          Vq3ss=0;
		  SwitchStateA=1;
          SwitchStateB=1;
          SwitchStateC=1;
          SwitchStateD=1;
          SwitchStateE=1;

		  }
    }
	 
       Vdq[0]=Vd1ss;
 		 Vdq[1]=Vq1ss;
		 Vdq[2]=Vd3ss;
		 Vdq[3]=Vq3ss;
		 IGBTState[0]=SwitchStateA;
		 IGBTState[1]=SwitchStateB;
		 IGBTState[2]=SwitchStateC;
		 IGBTState[3]=SwitchStateD;
		 IGBTState[4]=SwitchStateE;

         return 3;

}



int ClassicDTCPwmModulation_2level(ushort Channel, unsigned int IGBT_State, float PhaseCurrent)
{
   if(Channel >= MAX_PWM_CHANNELS )
    return -1;
  else
    {
	  if (PhaseCurrent>=0)
	    {
	    if (IGBT_State==1)
	     {
	       *(PWM_2level[Channel].LTCupON) = SwitchPeriod-T_temp;
           *(PWM_2level[Channel].LTCupOFF) = SwitchPeriod+1000;
           *(PWM_2level[Channel].LTCdownOFF) = SwitchPeriod-T_temp-DeadBand;
           *(PWM_2level[Channel].LTCdownON) = SwitchPeriod+1000;
	     }
	      if (IGBT_State==0)
	     {
	       *(PWM_2level[Channel].LTCupON) = SwitchPeriod+1000;
           *(PWM_2level[Channel].LTCupOFF) = T_temp;
           *(PWM_2level[Channel].LTCdownOFF)= SwitchPeriod+1000;
           *(PWM_2level[Channel].LTCdownON) = T_temp+DeadBand;  
	     }
   	 }

     if (PhaseCurrent<0)
   	 {
	    if (IGBT_State==1)
	     {
	       *(PWM_2level[Channel].LTCupON) =T_temp+DeadBand;
           *(PWM_2level[Channel].LTCupOFF) =SwitchPeriod+1000;
           *(PWM_2level[Channel].LTCdownOFF) =T_temp;
           *(PWM_2level[Channel].LTCdownON) = SwitchPeriod+1000;
	     }
	     if (IGBT_State==0)
	     {
	       *(PWM_2level[Channel].LTCupON) =SwitchPeriod+1000;
           *(PWM_2level[Channel].LTCupOFF) =SwitchPeriod-T_temp-DeadBand;
           *(PWM_2level[Channel].LTCdownOFF) =SwitchPeriod+1000;
           *(PWM_2level[Channel].LTCdownON) =SwitchPeriod-T_temp;  
	     }
  	 }


	      return 0;
    }
}


//-----------------2-level 5-phase 5-level Hysteresis Torque Band look up table for the classic DTC------------------

void DTCLookupTable_2level(float Ia,float Ib, float Ic, float Id, float Ie,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5])
{
	  
  //------------ in this function, the largest, second largest vectors and the midium redundant vectors 
  
    SectorNum_F=1;
    if (StatorFluxAng_F>(5.969026042))	 //19*pi/10
        SectorNum_F=1;    
    else if (StatorFluxAng_F>(5.340707511)) //17*pi/10
       SectorNum_F=10;
    else if (StatorFluxAng_F>(4.71238898))  //15*pi/10
       SectorNum_F=9 ; 
    else if (StatorFluxAng_F>(4.08407045))	//13*pi/10
       SectorNum_F=8;
    else if (StatorFluxAng_F>(3.455751919))	// 11*pi/10
       SectorNum_F=7;
    else if (StatorFluxAng_F>(2.827433388))	//9*pi/10
       SectorNum_F=6;
    else if (StatorFluxAng_F>(2.199114858))	// 7*pi/10
       SectorNum_F=5;
    else if (StatorFluxAng_F>(1.570796327))	//5*pi/10
       SectorNum_F=4;
    else if (StatorFluxAng_F>(0.942477796))		//3*pi/10
           SectorNum_F=3;
    else if (StatorFluxAng_F>(0.314159265))	   //pi/10
       SectorNum_F=2; 
    else
       SectorNum_F=1;
   
  //--------------------------Hysteresis band----------------------------------------
         phi=0;
      if (FlxErr+FluxBand<0)  
         phi=0;
      if (FlxErr-FluxBand>0)  
         phi=1;
	 
//	    Tor=0;
//      if (TorErr+TorqueBand<0)  
//         Tor=-1;
//      if (TorErr-TorqueBand>0) 
//         Tor=1;


  
         Tor=0;
      if (TorErr+TorqueBand<0)  
         Tor=-2;
      if (TorErr+TorqueBand/2<0&&TorErr+TorqueBand>0)  
         Tor=-1;
      if (TorErr-TorqueBand/2>0&&TorErr-TorqueBand<0 ) 
         Tor=1;
      if (TorErr-TorqueBand>=0) 
         Tor=2;
           
  //-----------------------------Back_Emf Calculation-----------------------
      BemfLevel=0;
      if (RotorSpeed>314/8) BemfLevel=1;
      if (RotorSpeed<-314/8) BemfLevel=-1;
	   
	   
   	// BemfLevel=0;

 
                 
 // %------------------------------Space Vector Selection based on Bemf info---- 
  
 if(BemfLevel==0)
 {     
  if (phi==1)
   {
    if (Tor==1||Tor==2)
        SwitchingPos=1; 
    if (Tor==-1||Tor==-2)
        SwitchingPos=9;
    }

  if (phi==0)
   {
    if (Tor==1||Tor==2)
        SwitchingPos=4; 
    if (Tor==-1||Tor==-2)
        SwitchingPos=6;    
   }
 }

if(BemfLevel==1)
 {  
  if (phi==1)
   {
    if (Tor==1||Tor==2)
        SwitchingPos=2; 
    if (Tor==-1||Tor==-2)
        SwitchingPos=9;   
   }

  if (phi==0)
   {
    if (Tor==1||Tor==2)
        SwitchingPos=3;   
    if (Tor==-1||Tor==-2)
        SwitchingPos=6;  
   }
 }
  
 if(BemfLevel==-1)
  {  
  if (phi==1)
    {
      if (Tor==1||Tor==2)
         SwitchingPos=1;  
      if (Tor==-1||Tor==-2)
         SwitchingPos=8;
    } 

  if (phi==0)
   {
      if (Tor==1||Tor==2)
        SwitchingPos=4;  
      if (Tor==-1||Tor==-2)
        SwitchingPos=7;  
   }
 }

 SwitchingPos=SwitchingPos+(SectorNum_F-1);
 SwitchingPos=SwitchingPos%10;
//    
//%----------------------------Using 36 degree vectors-----------------------

    
//   if (phi==1)
//    {
//     if (Tor==1)
//         SwitchingPos=2; 
//     if (Tor==-1)
//         SwitchingPos=8; 
//   	 }
//   if (phi==0)
//    {
//     if (Tor==1)
//         SwitchingPos=3; 
//     if (Tor==-1)
//         SwitchingPos=7;
//    }    
//  
//     SwitchingPos=SwitchingPos+(SectorNum_F-1);
//     SwitchingPos=SwitchingPos%10;

//--------------------------------------------------------------------------
  
  if (Tor==0)
  {    
     Vd1ss=0; 
     Vq1ss=0; 
     Vd3ss=0;
     Vq3ss=0;
	 SwitchStateA=1;
     SwitchStateB=1;
     SwitchStateC=1;
     SwitchStateD=1;
     SwitchStateE=1;

  }
  else
  {
  if (SwitchingPos==0)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==9||SectorNum_A==10)
	  if(StatorFluxAng_A>4.712238898||StatorFluxAng_A<1.570796327)
	      {
           if(Tor==2||Tor==-2)
		    {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=1;
              SwitchStateB=1;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=1;
		    }
           if(Tor==1||Tor==-1)   
            {
              Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));
		   
		      SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=1;
		    }
	      }
         
		  else //if ((Ia>=0&&HysteresisStatus==2)||(Ia<0&&HysteresisStatus==2))
		   {
		    Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		    SwitchStateA=1;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=0;
            SwitchStateE=0;
		  }
    }
      
  else if (SwitchingPos==1)
    {
     // if (SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6)
	   if(StatorFluxAng_A>=0.314159265&&StatorFluxAng_A<=3.455751919)
	     {

          if(Tor==2||Tor==-2)
         {
           Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
		  }
         if(Tor==1||Tor==-1)
	       {
            Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=1;
            SwitchStateC=0;
            SwitchStateD=1;
            SwitchStateE=0;
		   }
		}
		    
        else //if ((-Id>=0&&HysteresisStatus==2)||(-Id<0&&HysteresisStatus==2))
		   {
			Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=1;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=1;
		   }
    }
 else if (SwitchingPos==2)
    {
          // if (SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9)
	   if(StatorFluxAng_A>=2.199114858&&StatorFluxAng_A<=5.340707511)
	     {
		 if(Tor==2||Tor==-2)
           {
            Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=0;
		   }
         if(Tor==1||Tor==-1)
           {
		    Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=0;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=0;
		   }
		 }
		    
       	  else// if ((Ib>=0&&HysteresisStatus==2)||(Ib<0&&HysteresisStatus==2))
		   {
		 	 Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		 	 SwitchStateA=0;
             SwitchStateB=1;
             SwitchStateC=0;
             SwitchStateD=0;
             SwitchStateE=0;
		  }
      }
 else if (SwitchingPos==3)
   {
          //if (SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1||SectorNum_A==2)
	   if(StatorFluxAng_A>=4.08407045||StatorFluxAng_A<=0.942477796)
	     {
		   if(Tor==2||Tor==-2)
		   {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=1;
             SwitchStateC=1;
             SwitchStateD=0;
             SwitchStateE=0;
		    }
	      if(Tor==1||Tor==-1)
		    {
             Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=1;
             SwitchStateC=1;
             SwitchStateD=0;
             SwitchStateE=1;
		    }
		 }
			 			
		   	else //if ((-Ie>=0&&HysteresisStatus==2)||(-Ie<0&&HysteresisStatus==2))
			 {
			  	 Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));		  	 
			  	 SwitchStateA=1;
                 SwitchStateB=1;
                 SwitchStateC=1;
                 SwitchStateD=1;
                 SwitchStateE=0;
			 }
        }
  else if (SwitchingPos==4)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5)
	   if(StatorFluxAng_A>=5.969026042 || StatorFluxAng_A<=2.827433388)
	      {
		  if(Tor==2||Tor==-2)
            {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;
		     }
           if(Tor==1||Tor==-1)
	         {
              Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=0;
              SwitchStateD=1;
              SwitchStateE=0;
			  }
			}
			
		  else //if ((Ic>=0&&HysteresisStatus==2)||(Ic<0&&HysteresisStatus==2))
			{
			  Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			  
			  SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=0;
              SwitchStateE=0;
		    }
     }
   else if (SwitchingPos==5)
      {
     // if (SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8)
	     
	   if (StatorFluxAng_A>=1.570796327&&StatorFluxAng_A<=4.71238898)
	     {
		  if(Tor==2||Tor==-2)
            {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;
	         }
           if(Tor==1||Tor==-1)
            {
              Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=1;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;
			}
		 }
						
		   else// if ((-Ia>=0&&HysteresisStatus==2)||(-Ia<0&&HysteresisStatus==2))
		  {
			Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=0;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=1;
            SwitchStateE=1;
		  }
   }
   else if (SwitchingPos==6)
      {
      //if (SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1)
	    if(StatorFluxAng_A>=3.455751919||StatorFluxAng_A<=0.314159265)
	     {
		  if(Tor==2||Tor==-2)
            {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;
			}

	     if(Tor==1||Tor==-1)
            {
             Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=0;
             SwitchStateE=1;
            }
		 }
		 else// if ((Id>=0&&HysteresisStatus==2)||(Id<0&&HysteresisStatus==2))
		   {
		  	 Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));
 
		  	 SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=0;
   		  }
   }
   else if (SwitchingPos==7)
    {
     // if (SectorNum_A==10||SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4)
	   if(StatorFluxAng_A>=5.340707511 || StatorFluxAng_A<=2.199114858)
	     {
		    if(Tor==2||Tor==-2)
            {

              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=1;
              SwitchStateE=1;
		    }
            if(Tor==1||Tor==-1)
            {
              Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=0;
              SwitchStateD=1;
              SwitchStateE=1;
		   }
		}
		   
		 else //if ((-Ib>=0&&HysteresisStatus==2)||(-Ib<0&&HysteresisStatus==2))
		  {
		     Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		  	 SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;
		  }
      }
   else if (SwitchingPos==8)

    {
      //if (SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7)
	   if(StatorFluxAng_A>=0.942477796&&StatorFluxAng_A<=4.08407045) 
	     {
		    if(Tor==2||Tor==-2)
           {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=1;
		   }
           if(Tor==1||Tor==-1)
		   {
              Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=1;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=1;
              SwitchStateE=0;
			}
		  }
		    else // if ((Ie>=0&&HysteresisStatus==2)||(Ie<0&&HysteresisStatus==2)) 
			 {
               Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
               Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
               Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
               Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

               SwitchStateA=0;
               SwitchStateB=0;
               SwitchStateC=0;
               SwitchStateD=0;
               SwitchStateE=1;
             }
     }
  else if (SwitchingPos==9)
    {
      //if (SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10)
	    if (StatorFluxAng_A>=2.827433388 && StatorFluxAng_A<=5.969026042)
	     {
		    if(Tor==2||Tor==-2)
           {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=0;
             SwitchStateE=1;
		   }
           if(Tor==1||Tor==-1)
           {
             Vd1ss=0.2472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.2472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.6472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.6472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=0;
             SwitchStateE=1;
			}
		  }
 		    else //if ((-Ic>=0&&HysteresisStatus==2)||(-Ic<0&&HysteresisStatus==2))
			 {
			    Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
                Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
                Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
                Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			    SwitchStateA=1;
                SwitchStateB=1;
                SwitchStateC=0;
                SwitchStateD=1;
                SwitchStateE=1; 
			 }
 	 }
     
     else
         {
          Vd1ss=0; 
          Vq1ss=0;
          Vd3ss=0;
          Vq3ss=0;
		  SwitchStateA=1;
          SwitchStateB=1;
          SwitchStateC=1;
          SwitchStateD=1;
          SwitchStateE=1;

		  }
    }
	 
         Vdq[0]=Vd1ss;
 		 Vdq[1]=Vq1ss;
		 Vdq[2]=Vd3ss;
		 Vdq[3]=Vq3ss;
		 IGBTState[0]=SwitchStateA;
		 IGBTState[1]=SwitchStateB;
		 IGBTState[2]=SwitchStateC;
		 IGBTState[3]=SwitchStateD;
		 IGBTState[4]=SwitchStateE;

}
//
//
// -----------------------the following DCT is a 3 torque hysteresis band DTC algorithm

 void DTCLookupTableWith3HysteresisBand_2level(float Ia,float Ib, float Ic, float Id, float Ie,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5])
 {
	  
  //------------ in this function, the largest, second largest vectors and the midium redundant vectors 
  
    SectorNum_F=1;
    if (StatorFluxAng_F>(5.969026042))	 //19*pi/10
        SectorNum_F=1;    
    else if (StatorFluxAng_F>(5.340707511)) //17*pi/10
       SectorNum_F=10;
    else if (StatorFluxAng_F>(4.71238898))  //15*pi/10
       SectorNum_F=9 ; 
    else if (StatorFluxAng_F>(4.08407045))	//13*pi/10
       SectorNum_F=8;
    else if (StatorFluxAng_F>(3.455751919))	// 11*pi/10
       SectorNum_F=7;
    else if (StatorFluxAng_F>(2.827433388))	//9*pi/10
       SectorNum_F=6;
    else if (StatorFluxAng_F>(2.199114858))	// 7*pi/10
       SectorNum_F=5;
    else if (StatorFluxAng_F>(1.570796327))	//5*pi/10
       SectorNum_F=4;
    else if (StatorFluxAng_F>(0.942477796))		//3*pi/10
           SectorNum_F=3;
    else if (StatorFluxAng_F>(0.314159265))	   //pi/10
       SectorNum_F=2; 
    else
       SectorNum_F=1;
   
  //--------------------------Hysteresis band----------------------------------------
         phi=0;
      if (FlxErr+FluxBand<0)  
         phi=0;
      if (FlxErr-FluxBand>0)  
         phi=1;
	 
	    Tor=0;
      if (TorErr+TorqueBand<0)  
         Tor=-1;
      if (TorErr-TorqueBand>0) 
         Tor=1;

     
           
  //-----------------------------Back_Emf Calculation-----------------------
      BemfLevel=0;
      if (RotorSpeed>314/10) BemfLevel=1;
      if (RotorSpeed<-314/10) BemfLevel=-1;

 // %------------------------------Space Vector Selection based on Bemf info----  

// if(BemfLevel==0) 
// {    
//  if (phi==1)
//    {
//    if (Tor==1)
//        SwitchingPos=1;  
//    if (Tor==-1)
//        SwitchingPos=9; 
//    }
//
//  if (phi==0)
//    {
//    if (Tor==1)
//        SwitchingPos=4; 
//    if (Tor==-1)
//        SwitchingPos=6; 
//    }   
// } 
//
//
//if(BemfLevel==1)
//{  
//  if (phi==1)
//   {
//    if (Tor==1)
//        SwitchingPos=2; 
//    if (Tor==-1)
//        SwitchingPos=9;   
//   }
//
//  if (phi==0)
//    {
//    if (Tor==1)
//        SwitchingPos=3;   
//    if (Tor==-1)
//        SwitchingPos=6;
//    }   
//}
//  
// if(BemfLevel==-1) 
//  { 
//  if (phi==1)
//   {
//   if (Tor==1)
//        SwitchingPos=1;  
//    if (Tor==-1)
//        SwitchingPos=8; 
//   }
//
//  if (phi==0)
//   {
//    if (Tor==1)
//        SwitchingPos=4;   
//    if (Tor==-1)
//        SwitchingPos=7;  
//   }
// }
//
// SwitchingPos=SwitchingPos+(SectorNum_F-1);
// SwitchingPos=SwitchingPos%10;
//    

        
//%----------------------------Using 36 degree vectors-----------------------

//  if ((SectorNum_F<2*pi&&SectorNum_F>19*pi/10)||(SectorNum_F<2*pi/10&&SectorNum_F>pi/10)||(SectorNum_F<4*pi/10&&SectorNum_F>3*pi/10)||(SectorNum_F<6*pi/10&&SectorNum_F>5*pi/10)||(SectorNum_F<8*pi/10&&SectorNum_F>7*pi/10)||(SectorNum_F<10*pi/10&&SectorNum_F>9*pi/10)||(SectorNum_F<12*pi/10&&SectorNum_F>11*pi/10)||(SectorNum_F<14*pi/10&&SectorNum_F>13*pi/10)||(SectorNum_F<16*pi/10&&SectorNum_F>15*pi/10)||(SectorNum_F<18*pi/10&&SectorNum_F>17*pi/10))
// {
   if (phi==1)
    {
     if (Tor==1)
         SwitchingPos=1; //2
     if (Tor==-1)
         SwitchingPos=9; //8
   	 }
   if (phi==0)
    {
     if (Tor==1)
         SwitchingPos=4;  //3
     if (Tor==-1)
         SwitchingPos=6;  //7
    }    
  
     SwitchingPos=SwitchingPos+(SectorNum_F-1);
     SwitchingPos=SwitchingPos%10;
// }
// else// if ((SectorNum_F<2*pi&&SectorNum_F>19*pi/10)||(SectorNum_F<0.628318&&SectorNum_F>0.31415926)||(SectorNum_F<1.256637&&SectorNum_F>0.94245)||(SectorNum_F<1.8849&&SectorNum_F>1.570796)||(SectorNum_F<2.5133&&SectorNum_F>2.199115)||(SectorNum_F<3.1415926&&SectorNum_F>2.827433)||(SectorNum_F<3.7699&&SectorNum_F>3.455719)||(SectorNum_F<4.39823&&SectorNum_F>4.08401)||(SectorNum_F<5.02655&&SectorNum_F>4.712389)||(SectorNum_F<5.65487&&SectorNum_F>5.34071))
//  {
//  	  if (phi==1)
//    {
//     if (Tor==1)
//         SwitchingPos=2; 
//     if (Tor==-1)
//         SwitchingPos=8; 
//   	 }
//   if (phi==0)
//    {
//     if (Tor==1)
//         SwitchingPos=3; 
//     if (Tor==-1)
//         SwitchingPos=7;
//    }    
//  
//     SwitchingPos=SwitchingPos+(SectorNum_F-1);
//     SwitchingPos=SwitchingPos%10; 
//  }


//--------------------------------------------------------------------------
  
  if (Tor==0)
  {    
     Vd1ss=0; 
     Vq1ss=0; 
     Vd3ss=0;
     Vq3ss=0;
	 SwitchStateA=1;
     SwitchStateB=1;
     SwitchStateC=1;
     SwitchStateD=1;
     SwitchStateE=1;

  }
  else
  {
  if (SwitchingPos==0)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==9||SectorNum_A==10)
	  if(StatorFluxAng_A>4.712238898||StatorFluxAng_A<1.570796327)
	      {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=1;
              SwitchStateB=1;
              SwitchStateC=0;
              SwitchStateD=0;
              SwitchStateE=1;
	      }
         
		  else //if ((Ia>=0&&HysteresisStatus==2)||(Ia<0&&HysteresisStatus==2))
		   {
		    Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		    SwitchStateA=1;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=0;
            SwitchStateE=0;
		  }
    }
      
  else if (SwitchingPos==1)
    {
     // if (SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6)
	   if(StatorFluxAng_A>=0.314159265&&StatorFluxAng_A<=3.455751919)
	     {

           Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
           Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
           Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
           Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

           SwitchStateA=1;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
		}
		    
        else //if ((-Id>=0&&HysteresisStatus==2)||(-Id<0&&HysteresisStatus==2))
		   {
			Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=1;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=1;
		   }
    }
 else if (SwitchingPos==2)
    {
          // if (SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9)
	   if(StatorFluxAng_A>=2.199114858&&StatorFluxAng_A<=5.340707511)
	     {
            Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

            SwitchStateA=1;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=0;
            SwitchStateE=0;
		 }
		    
       	  else// if ((Ib>=0&&HysteresisStatus==2)||(Ib<0&&HysteresisStatus==2))
		   {
		 	 Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		 	 SwitchStateA=0;
             SwitchStateB=1;
             SwitchStateC=0;
             SwitchStateD=0;
             SwitchStateE=0;
		  }
      }
 else if (SwitchingPos==3)
   {
          //if (SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1||SectorNum_A==2)
	   if(StatorFluxAng_A>=4.08407045||StatorFluxAng_A<=0.942477796)
	     {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=1;
             SwitchStateC=1;
             SwitchStateD=0;
             SwitchStateE=0;
		 }
			 			
		   	else //if ((-Ie>=0&&HysteresisStatus==2)||(-Ie<0&&HysteresisStatus==2))
			 {
			  	 Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
                 Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
                 Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
                 Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));		  	 
			  	 SwitchStateA=1;
                 SwitchStateB=1;
                 SwitchStateC=1;
                 SwitchStateD=1;
                 SwitchStateE=0;
			 }
    }
  else if (SwitchingPos==4)
    {
     // if (SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4||SectorNum_A==5)
	   if(StatorFluxAng_A>=5.969026042 || StatorFluxAng_A<=2.827433388)
	       {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=1;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;
			}
			
		  else //if ((Ic>=0&&HysteresisStatus==2)||(Ic<0&&HysteresisStatus==2))
			{
			  Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			  
			  SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=0;
              SwitchStateE=0;
		    }
     }
   else if (SwitchingPos==5)
      {
     // if (SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7||SectorNum_A==8)
	     
	   if (StatorFluxAng_A>=1.570796327&&StatorFluxAng_A<=4.71238898)
	       {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=1;
              SwitchStateD=1;
              SwitchStateE=0;
		   }
						
		   else// if ((-Ia>=0&&HysteresisStatus==2)||(-Ia<0&&HysteresisStatus==2))
		   {
			Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
            Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
            Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
            Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			SwitchStateA=0;
            SwitchStateB=1;
            SwitchStateC=1;
            SwitchStateD=1;
            SwitchStateE=1;
		   }
   }
   else if (SwitchingPos==6)
      {
      //if (SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10||SectorNum_A==1)
	    if(StatorFluxAng_A>=3.455751919||StatorFluxAng_A<=0.314159265)
	       {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;
		   }
		 else// if ((Id>=0&&HysteresisStatus==2)||(Id<0&&HysteresisStatus==2))
		    {
		  	 Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));
 
		  	 SwitchStateA=0;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=0;
   		   }
   }
   else if (SwitchingPos==7)
    {
     // if (SectorNum_A==10||SectorNum_A==1||SectorNum_A==2||SectorNum_A==3||SectorNum_A==4)
	   if(StatorFluxAng_A>=5.340707511 || StatorFluxAng_A<=2.199114858)
	        {
              Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
              Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
              Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
              Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

              SwitchStateA=0;
              SwitchStateB=0;
              SwitchStateC=0;
              SwitchStateD=1;
              SwitchStateE=1;
	     	}
		   
		 else //if ((-Ib>=0&&HysteresisStatus==2)||(-Ib<0&&HysteresisStatus==2))
		   {
		     Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

		  	 SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=1;
             SwitchStateD=1;
             SwitchStateE=1;
		   }
      }
   else if (SwitchingPos==8)

    {
      //if (SectorNum_A==3||SectorNum_A==4||SectorNum_A==5||SectorNum_A==6||SectorNum_A==7)
	   if(StatorFluxAng_A>=0.942477796&&StatorFluxAng_A<=4.08407045) 
	       {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=1;
             SwitchStateE=1;
		   }
		    else // if ((Ie>=0&&HysteresisStatus==2)||(Ie<0&&HysteresisStatus==2)) 
			 {
               Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
               Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
               Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
               Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

               SwitchStateA=0;
               SwitchStateB=0;
               SwitchStateC=0;
               SwitchStateD=0;
               SwitchStateE=1;
             }
     }
  else if (SwitchingPos==9)
    {
      //if (SectorNum_A==6||SectorNum_A==7||SectorNum_A==8||SectorNum_A==9||SectorNum_A==10)
	    if (StatorFluxAng_A>=2.827433388 && StatorFluxAng_A<=5.969026042)
	       {
             Vd1ss=0.6472*Vdc*cos((SwitchingPos)*pi/5);
             Vq1ss=0.6472*Vdc*sin((SwitchingPos)*pi/5);
             Vd3ss=0.2472*Vdc*cos(fmod((pi+3*SwitchingPos*pi/5),2*pi));
             Vq3ss=0.2472*Vdc*sin(fmod((pi+3*SwitchingPos*pi/5),2*pi));

             SwitchStateA=1;
             SwitchStateB=0;
             SwitchStateC=0;
             SwitchStateD=0;
             SwitchStateE=1;
		   }
 		    else //if ((-Ic>=0&&HysteresisStatus==2)||(-Ic<0&&HysteresisStatus==2))
			 {
			    Vd1ss=0.4*Vdc*cos((SwitchingPos)*pi/5);
                Vq1ss=0.4*Vdc*sin((SwitchingPos)*pi/5);
                Vd3ss=0.4*Vdc*cos(fmod((3*SwitchingPos*pi/5),2*pi));
                Vq3ss=0.4*Vdc*sin(fmod((3*SwitchingPos*pi/5),2*pi));

			    SwitchStateA=1;
                SwitchStateB=1;
                SwitchStateC=0;
                SwitchStateD=1;
                SwitchStateE=1; 
			 }
 	 }
     
     else
         {
          Vd1ss=0; 
          Vq1ss=0;
          Vd3ss=0;
          Vq3ss=0;
		  SwitchStateA=1;
          SwitchStateB=1;
          SwitchStateC=1;
          SwitchStateD=1;
          SwitchStateE=1;

		  }
    }
	 
         Vdq[0]=Vd1ss;
 		 Vdq[1]=Vq1ss;
		 Vdq[2]=Vd3ss;
		 Vdq[3]=Vq3ss;
		 IGBTState[0]=SwitchStateA;
		 IGBTState[1]=SwitchStateB;
		 IGBTState[2]=SwitchStateC;
		 IGBTState[3]=SwitchStateD;
		 IGBTState[4]=SwitchStateE;

}


